/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.ufo;

import java.util.EnumMap;
import java.util.LinkedList;
import java.util.Map;
import lonelycoders.ufohippa.game.ufo.Bullet;
import lonelycoders.ufohippa.game.ufo.UfoSkin;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.game.util.Vector2;

public class Ufo {
    public static final float WIDTH = 1.8f;
    public static final float HEIGHT = 0.9f;
    public static final Vector2 DIAMETER = new Vector2(1.8f, 0.9f);
    public static final Vector2 RADIUS = new Vector2(0.9f, 0.45f);
    private static final float SLOW_DOWN = 0.98f;
    private static final float ACCELERATION = 0.002f;
    private static final float BULLET_SPEED = 0.15f;
    private static final int RELOAD_TIME = 50;
    private static final int TELEPORT_RELOAD_TIME = 200;
    private final String playerName;
    private final Vector2 position = new Vector2(0.0f, 0.0f);
    private final Vector2 velocity = new Vector2(0.0f, 0.0f);
    private float mass;
    private UfoSkin skin;
    private final Map<Control, ControlState> controls = new EnumMap<Control, ControlState>(Control.class);
    private int reload = 50;
    private int teleportReload = 200;
    private static final int CROSSHAIR_HISTORY_LENGTH = 40;
    private final LinkedList<Vector2> crosshairHistory = new LinkedList();
    private final boolean aiPlayer;

    public Ufo(String playerName, Vector2 position, boolean aiPlayer) {
        this.playerName = playerName;
        this.aiPlayer = aiPlayer;
        this.setPosition(position);
        for (Control control : Control.values()) {
            this.controls.put(control, ControlState.RELEASED);
        }
        for (int i = 0; i < 40; ++i) {
            this.crosshairHistory.add(new Vector2(0.0f, 0.0f));
        }
    }

    public Ufo(Ufo original) {
        this.playerName = original.playerName;
        this.aiPlayer = original.aiPlayer;
        this.setPosition(original.position);
        this.setVelocity(original.velocity);
        this.controls.putAll(original.controls);
        for (int i = 0; i < 40; ++i) {
            this.crosshairHistory.add(new Vector2(original.crosshairHistory.get(i)));
        }
    }

    public void setSkin(UfoSkin skin) {
        this.skin = skin;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public Vector2 getVelocity() {
        return this.velocity;
    }

    public UfoSkin getSkin() {
        return this.skin;
    }

    public void setControlState(Control control, boolean pressed) {
        ControlState oldState = this.controls.get((Object)control);
        ControlState newState = oldState.getNextState(pressed);
        this.controls.put(control, newState);
    }

    public boolean getControlState(Control control) {
        ControlState value = this.controls.get((Object)control);
        return value != ControlState.RELEASED;
    }

    public void setPosition(float x, float y) {
        this.position.x = x;
        this.position.y = y;
    }

    public void setPosition(Vector2 position) {
        this.position.x = position.x;
        this.position.y = position.y;
    }

    public void setVelocity(Vector2 velocity) {
        this.velocity.x = velocity.x;
        this.velocity.y = velocity.y;
    }

    public void update() {
        int crosshairX = 0;
        int crosshairY = 0;
        if (this.getControlState(Control.LEFT)) {
            this.velocity.x -= 0.002f;
            --crosshairX;
        }
        if (this.getControlState(Control.RIGHT)) {
            this.velocity.x += 0.002f;
            ++crosshairX;
        }
        if (this.getControlState(Control.DOWN)) {
            this.velocity.y -= 0.002f;
            --crosshairY;
        }
        if (this.getControlState(Control.UP)) {
            this.velocity.y += 0.002f;
            ++crosshairY;
        }
        if (crosshairX != 0 || crosshairY != 0) {
            this.crosshairHistory.add(new Vector2(crosshairX, crosshairY));
            this.crosshairHistory.removeFirst();
        }
        this.velocity.scale(0.98f);
        this.position.add(this.velocity);
        for (Control control : Control.values()) {
            ControlState oldState = this.controls.get((Object)control);
            ControlState newState = oldState.getAutoNextState();
            this.controls.put(control, newState);
        }
        this.reload = Math.max(0, this.reload - 1);
        this.teleportReload = Math.max(0, this.teleportReload - 1);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public Vector2 getCrosshair() {
        Vector2 crosshair = new Vector2(0.0f, 0.0f);
        for (Vector2 singleCrosshair : this.crosshairHistory) {
            crosshair.add(singleCrosshair);
        }
        if ((double)crosshair.getLength2() < 0.01) {
            return null;
        }
        crosshair.normalize();
        return crosshair;
    }

    public Bullet shoot() {
        if (this.reload == 0) {
            Vector2 bulletPosition = new Vector2(this.position);
            Vector2 bulletVelocity = this.getCrosshair();
            if (bulletVelocity == null) {
                return null;
            }
            bulletPosition.addScaled(new Vector2(bulletVelocity.x * 1.8f, bulletVelocity.y * 0.9f), 0.6f);
            bulletPosition.addScaled(this.velocity, 10.0f);
            bulletVelocity.scale(0.15f);
            this.reload = 50;
            return new Bullet((float)Math.random(), bulletPosition, bulletVelocity, ColorRGB.BLACK);
        }
        return null;
    }

    public ColorRGB getBulletColor() {
        ColorRGB color = this.skin.getColor();
        return color.blend(ColorRGB.WHITE, 0.5f);
    }

    public void resetControls() {
        for (Control control : Control.values()) {
            this.controls.put(control, ControlState.RELEASED);
        }
    }

    public boolean teleport() {
        if (this.teleportReload == 0) {
            this.teleportReload = 200;
            return true;
        }
        return false;
    }

    public boolean isAIPlayer() {
        return this.aiPlayer;
    }

    public static enum ControlState {
        RELEASED,
        JUST_PRESSED,
        PRESSED,
        WILL_BE_RELEASED;

        private ControlState nextPressedState;
        private ControlState nextReleasedState;
        private ControlState autoNextState;

        private void initialize(ControlState nextPressedState, ControlState nextReleasedState, ControlState autoNextState) {
            this.nextPressedState = nextPressedState;
            this.nextReleasedState = nextReleasedState;
            this.autoNextState = autoNextState;
        }

        public ControlState getNextState(boolean pressed) {
            return pressed ? this.nextPressedState : this.nextReleasedState;
        }

        public ControlState getAutoNextState() {
            return this.autoNextState;
        }

        static {
            RELEASED.initialize(JUST_PRESSED, RELEASED, RELEASED);
            JUST_PRESSED.initialize(PRESSED, WILL_BE_RELEASED, PRESSED);
            PRESSED.initialize(PRESSED, RELEASED, PRESSED);
            WILL_BE_RELEASED.initialize(JUST_PRESSED, WILL_BE_RELEASED, RELEASED);
        }
    }

    public static enum Control {
        LEFT,
        RIGHT,
        UP,
        DOWN,
        FIRE;

    }
}

