/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.level;

import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lonelycoders.ufohippa.game.level.Tile;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.util.ResourceUtil;
import lonelycoders.ufohippa.util.XmlException;
import lonelycoders.ufohippa.util.XmlUtil;
import org.w3c.dom.Element;

public class TileSet {
    private static Map<String, Tile.Collision> collisions = new HashMap<String, Tile.Collision>();
    private final Map<Integer, Tile> tiles;
    private final Tile defaultTile;
    private final String name;
    private final Map<SpecialTile, Tile> specialTiles;

    public TileSet(String name) throws XmlException {
        collisions.put("solid", Tile.Collision.SOLID);
        this.tiles = new LinkedHashMap<Integer, Tile>();
        this.specialTiles = new EnumMap<SpecialTile, Tile>(SpecialTile.class);
        this.name = name;
        try {
            Element elementTileset = XmlUtil.parseXml(ResourceUtil.getResource("tiles/" + name));
            int defaultTileId = XmlUtil.getIntAttribute(elementTileset, "default");
            for (Element elementTile : XmlUtil.getChildElements(elementTileset, "tile")) {
                int id = XmlUtil.getIntAttribute(elementTile, "id");
                String stringCollision = XmlUtil.getStringAttribute(elementTile, "collision", "");
                Tile.Collision collision = collisions.containsKey(stringCollision) ? collisions.get(stringCollision) : Tile.Collision.NONE;
                Tile tile = new Tile(id, collision);
                if (XmlUtil.hasChild(elementTile, "image2d")) {
                    Element elementImage2d = XmlUtil.getChildElement(elementTile, "image2d");
                    String imageName = "tiles/" + XmlUtil.getStringAttribute(elementImage2d, "name");
                    tile.setImage2dName(imageName);
                }
                if (XmlUtil.hasChild(elementTile, "model")) {
                    Element elementModel = XmlUtil.getChildElement(elementTile, "model");
                    String modelClass = "lonelycoders.ufohippa.client.renderer.gl.tiles." + XmlUtil.getStringAttribute(elementModel, "class");
                    tile.setModelClass(modelClass);
                }
                tile.setVisible(XmlUtil.getBooleanAttribute(elementTile, "visible", true));
                tile.setSupportsColoring(XmlUtil.getBooleanAttribute(elementTile, "colored", false));
                this.tiles.put(id, tile);
            }
            this.defaultTile = this.tiles.get(defaultTileId);
            this.specialTiles.put(SpecialTile.DEFAULT, this.defaultTile);
            Element elementEdges = XmlUtil.getChildElement(elementTileset, "edges");
            this.specialTiles.put(SpecialTile.TOP_LEFT, this.tiles.get(XmlUtil.getIntAttribute(elementEdges, "topleft")));
            this.specialTiles.put(SpecialTile.TOP, this.tiles.get(XmlUtil.getIntAttribute(elementEdges, "top")));
            this.specialTiles.put(SpecialTile.TOP_RIGHT, this.tiles.get(XmlUtil.getIntAttribute(elementEdges, "topright")));
            this.specialTiles.put(SpecialTile.LEFT, this.tiles.get(XmlUtil.getIntAttribute(elementEdges, "left")));
            this.specialTiles.put(SpecialTile.RIGHT, this.tiles.get(XmlUtil.getIntAttribute(elementEdges, "right")));
            this.specialTiles.put(SpecialTile.BOTTOM_LEFT, this.tiles.get(XmlUtil.getIntAttribute(elementEdges, "bottomleft")));
            this.specialTiles.put(SpecialTile.BOTTOM, this.tiles.get(XmlUtil.getIntAttribute(elementEdges, "bottom")));
            this.specialTiles.put(SpecialTile.BOTTOM_RIGHT, this.tiles.get(XmlUtil.getIntAttribute(elementEdges, "bottomright")));
        }
        catch (IOException e) {
            Logger.exception(e);
            throw new XmlException("Failed to load tileset", e);
        }
        catch (XmlException e) {
            Logger.exception(e);
            throw new XmlException("Failed to load tileset", e);
        }
    }

    public Iterable<Tile> getAllTiles() {
        return this.tiles.values();
    }

    public Tile getTile(int id) {
        if (this.tiles.containsKey(id)) {
            return this.tiles.get(id);
        }
        Logger.warning("Trying to load unsupported tile from " + this.name + ": " + id);
        return this.defaultTile;
    }

    public Tile getSpecialTile(SpecialTile specialTile) {
        return this.specialTiles.get((Object)specialTile);
    }

    public String getName() {
        return this.name;
    }

    public static enum SpecialTile {
        DEFAULT,
        TOP_LEFT,
        TOP,
        TOP_RIGHT,
        LEFT,
        RIGHT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT;

    }
}

