/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.level;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.game.level.LevelUtil;
import lonelycoders.ufohippa.game.level.Teleport;
import lonelycoders.ufohippa.game.level.Tile;
import lonelycoders.ufohippa.game.level.TileMap;
import lonelycoders.ufohippa.game.level.TileSet;
import lonelycoders.ufohippa.game.util.Vector2;

public class Level {
    private final LevelDescriptor levelDescriptor;
    private final String author;
    private final TileSet tileSet;
    private final TileMap tiles;
    private final List<Teleport> teleports = new ArrayList<Teleport>();
    private Vector2[] startingPositions;
    private Set<LevelUtil.TilePosition> availablePositions;

    public Level(LevelDescriptor levelDescriptor, String author, TileSet tileSet) {
        this(levelDescriptor, author, new TileMap(40, 30), tileSet);
        this.fixBorders();
        Tile defaultTile = tileSet.getSpecialTile(TileSet.SpecialTile.DEFAULT);
        for (int y = 1; y < this.tiles.getHeight() - 1; ++y) {
            for (int x = 1; x < this.tiles.getWidth() - 1; ++x) {
                this.tiles.setTile(x, y, defaultTile);
            }
        }
        this.initializeStartingPositions();
    }

    public void fixBorders() {
        int width = this.tiles.getWidth();
        int height = this.tiles.getHeight();
        this.tiles.setTile(0, 0, this.tileSet.getSpecialTile(TileSet.SpecialTile.BOTTOM_LEFT));
        this.tiles.setTile(width - 1, 0, this.tileSet.getSpecialTile(TileSet.SpecialTile.BOTTOM_RIGHT));
        this.tiles.setTile(0, height - 1, this.tileSet.getSpecialTile(TileSet.SpecialTile.TOP_LEFT));
        this.tiles.setTile(width - 1, height - 1, this.tileSet.getSpecialTile(TileSet.SpecialTile.TOP_RIGHT));
        for (int x = 1; x < width - 1; ++x) {
            this.tiles.setTile(x, 0, this.tileSet.getSpecialTile(TileSet.SpecialTile.BOTTOM));
            this.tiles.setTile(x, height - 1, this.tileSet.getSpecialTile(TileSet.SpecialTile.TOP));
        }
        for (int y = 1; y < height - 1; ++y) {
            this.tiles.setTile(0, y, this.tileSet.getSpecialTile(TileSet.SpecialTile.LEFT));
            this.tiles.setTile(width - 1, y, this.tileSet.getSpecialTile(TileSet.SpecialTile.RIGHT));
        }
    }

    public Level(LevelDescriptor levelDescriptor, String author, TileMap tiles, TileSet tileSet) {
        this.levelDescriptor = levelDescriptor;
        this.author = author;
        this.tiles = tiles;
        this.tileSet = tileSet;
    }

    public void initializeStartingPositions() {
        this.availablePositions = LevelUtil.findAvailablePositions(this.tiles, this.teleports);
        this.startingPositions = LevelUtil.getStartingPositions(this.tiles, this.availablePositions);
    }

    public String getAuthor() {
        return this.author;
    }

    public int getWidth() {
        return this.tiles.getWidth();
    }

    public int getHeight() {
        return this.tiles.getHeight();
    }

    public Tile getTile(int x, int y) {
        return this.tiles.getTile(x, y);
    }

    public String toString() {
        return "Level{name='" + this.levelDescriptor.getName() + '\'' + '}';
    }

    public Vector2[] getStartingPositions() {
        return this.startingPositions;
    }

    public TileMap getTiles() {
        return this.tiles;
    }

    public Set<LevelUtil.TilePosition> getAvailablePositions() {
        return this.availablePositions;
    }

    public List<Teleport> getTeleports() {
        return this.teleports;
    }

    public TileSet getTileSet() {
        return this.tileSet;
    }

    public LevelDescriptor getDescriptor() {
        return this.levelDescriptor;
    }

    public void insertColumn(int column) {
        for (Teleport teleport : this.teleports) {
            if (teleport.getX() < column) continue;
            teleport.setX(teleport.getX() + 1);
        }
        this.tiles.insertColumn(column);
    }

    public void insertRow(int row) {
        for (Teleport teleport : this.teleports) {
            if (teleport.getY() < row) continue;
            teleport.setY(teleport.getY() + 1);
        }
        this.tiles.insertRow(row);
    }

    public void removeColumn(int column) {
        Iterator<Teleport> it = this.teleports.iterator();
        while (it.hasNext()) {
            Teleport teleport = it.next();
            if (teleport.getX() == column) {
                it.remove();
            }
            if (teleport.getX() <= column) continue;
            teleport.setX(teleport.getX() - 1);
        }
        this.tiles.removeColumn(column);
    }

    public void removeRow(int row) {
        Iterator<Teleport> it = this.teleports.iterator();
        while (it.hasNext()) {
            Teleport teleport = it.next();
            if (teleport.getY() == row) {
                it.remove();
            }
            if (teleport.getY() <= row) continue;
            teleport.setY(teleport.getY() - 1);
        }
        this.tiles.removeRow(row);
    }
}

