/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.ai.pathfindingai;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lonelycoders.ufohippa.game.ai.pathfindingai.Estimator;
import lonelycoders.ufohippa.game.level.Level;
import lonelycoders.ufohippa.game.level.LevelUtil;

public class MultiTargetEstimator
implements Estimator {
    private final Level level;
    private final Set<LevelUtil.TilePosition> targets;

    public MultiTargetEstimator(Level level, Collection<LevelUtil.TilePosition> targets) {
        this.level = level;
        this.targets = new HashSet<LevelUtil.TilePosition>(targets);
    }

    @Override
    public float getEstimate(LevelUtil.TilePosition currentPosition) {
        float minEstimate = Float.MAX_VALUE;
        for (LevelUtil.TilePosition target : this.targets) {
            int deltaX = target.getX() - currentPosition.getX();
            int deltaY = target.getY() - currentPosition.getY();
            float estimate = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
            minEstimate = Math.min(minEstimate, estimate);
        }
        return minEstimate;
    }

    @Override
    public boolean isFinished(int iteration, LevelUtil.TilePosition position) {
        return this.targets.contains(position);
    }

    @Override
    public float getPositionPenalty(int tileX, int tileY) {
        int adjacentBlocked = 0;
        if (!LevelUtil.isAvailablePosition(this.level.getTiles(), tileX, tileY - 1)) {
            ++adjacentBlocked;
        }
        if (!LevelUtil.isAvailablePosition(this.level.getTiles(), tileX - 1, tileY)) {
            ++adjacentBlocked;
        }
        if (!LevelUtil.isAvailablePosition(this.level.getTiles(), tileX + 1, tileY)) {
            ++adjacentBlocked;
        }
        if (!LevelUtil.isAvailablePosition(this.level.getTiles(), tileX, tileY + 1)) {
            ++adjacentBlocked;
        }
        float[] penalties = new float[]{0.0f, 0.4f, 0.5f, 0.6f, 0.7f};
        return penalties[adjacentBlocked];
    }
}

