/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game.ai.pathfindingai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import lonelycoders.ufohippa.game.ai.pathfindingai.Estimator;
import lonelycoders.ufohippa.game.ai.pathfindingai.Route;
import lonelycoders.ufohippa.game.ai.pathfindingai.RouteNode;
import lonelycoders.ufohippa.game.level.Level;
import lonelycoders.ufohippa.game.level.LevelUtil;
import lonelycoders.ufohippa.game.level.Teleport;

public class LevelAStar {
    private final Queue<RouteNode> queue = new PriorityQueue<RouteNode>();
    private final Set<LevelUtil.TilePosition> visited = new HashSet<LevelUtil.TilePosition>();
    private final Level level;
    private final Map<LevelUtil.TilePosition, Collection<LevelUtil.TilePosition>> teleportTargets = new HashMap<LevelUtil.TilePosition, Collection<LevelUtil.TilePosition>>();
    private boolean allTeleports;

    public LevelAStar(Level level) {
        this.level = level;
        this.randomizeTeleports(false);
    }

    public void randomizeTeleports(boolean all) {
        for (Teleport teleport : this.level.getTeleports()) {
            if (teleport.getType() != Teleport.Type.NORMAL) continue;
            LevelUtil.TilePosition source = new LevelUtil.TilePosition(teleport.getX(), teleport.getY());
            ArrayList<LevelUtil.TilePosition> targets = new ArrayList<LevelUtil.TilePosition>();
            for (Teleport targetTeleport : this.level.getTeleports()) {
                if (targetTeleport.getType() != Teleport.Type.NORMAL || targetTeleport == teleport) continue;
                targets.add(new LevelUtil.TilePosition(targetTeleport.getX(), targetTeleport.getY()));
            }
            ArrayList<LevelUtil.TilePosition> targetPositions = new ArrayList<LevelUtil.TilePosition>();
            if (all) {
                targetPositions.addAll(targets);
            } else {
                targetPositions.add((LevelUtil.TilePosition)targets.get((int)(Math.random() * (double)targets.size())));
            }
            this.teleportTargets.put(source, targetPositions);
        }
        this.allTeleports = all;
    }

    public Route findRoute(LevelUtil.TilePosition start, Estimator estimator, boolean escape) {
        this.queue.clear();
        this.visited.clear();
        this.enqueue(null, start, 0.0f, false, estimator);
        int iteration = 0;
        RouteNode bestPath = null;
        while (!this.queue.isEmpty()) {
            LevelUtil.TilePosition position;
            RouteNode node = this.queue.remove();
            if (bestPath == null || node.compareTo(bestPath) < 0) {
                bestPath = node;
            }
            if (this.visited.contains(position = node.getPosition())) continue;
            this.visited.add(position);
            if (estimator.isFinished(iteration, position)) {
                return new Route(node);
            }
            int x = position.getX();
            int y = position.getY();
            float currentCost = node.getCurrentCost();
            float adjacentCost = currentCost + 1.0f;
            float diagonalCost = currentCost + 1.1f;
            boolean bottomOk = this.enqueue(node, x, y - 1, adjacentCost, false, estimator);
            boolean leftOk = this.enqueue(node, x - 1, y, adjacentCost, false, estimator);
            boolean rightOk = this.enqueue(node, x + 1, y, adjacentCost, false, estimator);
            boolean topOk = this.enqueue(node, x, y + 1, adjacentCost, false, estimator);
            if (leftOk && bottomOk) {
                this.enqueue(node, x - 1, y - 1, diagonalCost, false, estimator);
            }
            if (rightOk && bottomOk) {
                this.enqueue(node, x + 1, y - 1, diagonalCost, false, estimator);
            }
            if (leftOk && topOk) {
                this.enqueue(node, x - 1, y + 1, diagonalCost, false, estimator);
            }
            if (rightOk && topOk) {
                this.enqueue(node, x + 1, y + 1, diagonalCost, false, estimator);
            }
            if (this.teleportTargets.containsKey(position)) {
                for (LevelUtil.TilePosition targetPosition : this.teleportTargets.get(position)) {
                    this.enqueue(node, targetPosition.getX(), targetPosition.getY(), currentCost, true, estimator);
                }
            }
            ++iteration;
        }
        if (!this.allTeleports && !escape) {
            this.randomizeTeleports(true);
            return this.findRoute(start, estimator, false);
        }
        return new Route(bestPath);
    }

    private boolean enqueue(RouteNode previousNode, int x, int y, float currentCost, boolean discontinuous, Estimator estimator) {
        if (LevelUtil.isAvailablePosition(this.level.getTiles(), x, y)) {
            this.enqueue(previousNode, new LevelUtil.TilePosition(x, y), currentCost + estimator.getPositionPenalty(x, y), discontinuous, estimator);
            return true;
        }
        return false;
    }

    private void enqueue(RouteNode previousNode, LevelUtil.TilePosition position, float currentCost, boolean discontinuous, Estimator estimator) {
        if (!this.visited.contains(position)) {
            float estimateLeft = estimator.getEstimate(position);
            for (Teleport teleport : this.level.getTeleports()) {
                if (teleport.getType() != Teleport.Type.NORMAL) continue;
                estimateLeft = Math.min(estimateLeft, estimator.getEstimate(new LevelUtil.TilePosition(teleport.getX(), teleport.getY())));
            }
            this.queue.offer(new RouteNode(previousNode, position, currentCost, estimateLeft, discontinuous));
        }
    }
}

