/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lonelycoders.ufohippa.game.level.Level;
import lonelycoders.ufohippa.game.level.Tile;
import lonelycoders.ufohippa.game.ufo.Bullet;
import lonelycoders.ufohippa.game.ufo.Ufo;
import lonelycoders.ufohippa.game.util.Vector2;

public class RoundBase {
    private static final int FPS = 100;
    protected static final double FRAME_LENGTH = 0.01;
    private static final float ELASTICITY = 0.85f;
    protected final Level level;
    protected final Collection<Ufo> ufos;
    protected Ufo tagUfo;
    private double safeTagTimer;
    protected final Map<Ufo, Double> tagTimes = new HashMap<Ufo, Double>();
    protected final Map<Integer, Bullet> bullets = new HashMap<Integer, Bullet>();
    protected int frameCounter = 0;

    public RoundBase(Level level, Collection<Ufo> ufos) {
        this.level = level;
        this.ufos = ufos;
    }

    public RoundBase(RoundBase original) {
        this.level = original.level;
        ArrayList<Ufo> ufos = new ArrayList<Ufo>();
        HashMap<Ufo, Ufo> ufoMap = new HashMap<Ufo, Ufo>();
        for (Ufo ufo : original.ufos) {
            Ufo newUfo = new Ufo(ufo);
            ufoMap.put(ufo, newUfo);
            ufos.add(newUfo);
        }
        this.ufos = ufos;
        this.tagUfo = (Ufo)ufoMap.get(original.tagUfo);
        this.safeTagTimer = original.safeTagTimer;
        for (Map.Entry entry : original.tagTimes.entrySet()) {
            this.tagTimes.put((Ufo)ufoMap.get(entry.getKey()), (Double)entry.getValue());
        }
        for (Map.Entry entry : original.bullets.entrySet()) {
            this.bullets.put((Integer)entry.getKey(), new Bullet((Bullet)entry.getValue()));
        }
    }

    public void setTagUfo(Ufo tagUfo) {
        this.tagUfo = tagUfo;
        this.safeTagTimer = 2.0;
    }

    public Ufo getTagUfo() {
        return this.tagUfo;
    }

    public boolean isSafeTag() {
        return this.safeTagTimer > 0.0;
    }

    public Level getLevel() {
        return this.level;
    }

    public void updateConstantRate() {
        if (this.tagUfo != null) {
            this.safeTagTimer -= 0.01;
            if (this.safeTagTimer < 0.0) {
                this.safeTagTimer = 0.0;
            }
            if (!this.isSafeTag()) {
                this.tagTimes.put(this.tagUfo, this.tagTimes.get(this.tagUfo) + 0.01);
            }
        }
        for (Ufo ufo : this.ufos) {
            ufo.update();
        }
        this.checkUfoUfoCollisions();
        this.checkUfoTileCollisions();
        ++this.frameCounter;
    }

    public void updateUnsynchronizedConstantRate() {
        for (Bullet bullet : this.bullets.values()) {
            bullet.update();
        }
        this.checkBulletTileCollisions();
    }

    private void checkUfoUfoCollisions() {
        for (Ufo ufo1 : this.ufos) {
            for (Ufo ufo2 : this.ufos) {
                if (ufo1 == ufo2) break;
                float strength = this.checkUfoUfoCollision(ufo1, ufo2);
                if (!(strength > 0.0f)) continue;
                this.ufosCollided(ufo1, ufo2, strength);
            }
        }
    }

    private void checkUfoTileCollisions() {
        for (Ufo ufo : this.ufos) {
            this.checkUfoTileCollision(ufo);
        }
    }

    private void checkBulletTileCollisions() {
        HashMap<Integer, Bullet> map = new HashMap<Integer, Bullet>(this.bullets);
        for (Map.Entry bulletEntry : map.entrySet()) {
            boolean destroyed = this.checkBulletTileCollision((Bullet)bulletEntry.getValue());
            if (!destroyed) continue;
            this.bulletDestroyed((Integer)bulletEntry.getKey(), null);
        }
    }

    protected void checkBulletUfoCollisions() {
        HashMap<Integer, Bullet> map = new HashMap<Integer, Bullet>(this.bullets);
        for (Map.Entry bulletEntry : map.entrySet()) {
            for (Ufo ufo : this.ufos) {
                boolean destroyed = this.checkBulletUfoCollision((Bullet)bulletEntry.getValue(), ufo);
                if (!destroyed) continue;
                this.bulletDestroyed((Integer)bulletEntry.getKey(), ufo);
            }
        }
    }

    protected void ufosCollided(Ufo ufo1, Ufo ufo2, float strength) {
    }

    protected void bulletDestroyed(int bulletId, Ufo ufo) {
        Bullet bullet = this.bullets.get(bulletId);
        if (bullet != null) {
            bullet.setAlive(false);
        }
    }

    protected void bulletBounced() {
    }

    private float checkUfoUfoCollision(Ufo ufo1, Ufo ufo2) {
        Vector2 ufo1Position = ufo1.getPosition();
        Vector2 ufo2Position = ufo2.getPosition();
        Vector2 positionDelta = new Vector2(ufo2Position.x - ufo1Position.x, ufo2Position.y - ufo1Position.y);
        Vector2 scaledPositionDelta = new Vector2(positionDelta);
        scaledPositionDelta.divide(Ufo.DIAMETER);
        float testDot = scaledPositionDelta.getLength2();
        if (testDot < 1.0f) {
            Vector2 move = new Vector2(positionDelta);
            move.multiply(Ufo.RADIUS);
            move.scale(1.0f - testDot);
            ufo1Position.sub(move);
            ufo2Position.add(move);
            Vector2 ufo1Velocity = ufo1.getVelocity();
            Vector2 ufo2Velocity = ufo2.getVelocity();
            Vector2 speedDelta = new Vector2(ufo2Velocity.x - ufo1Velocity.x, ufo2Velocity.y - ufo1Velocity.y);
            Vector2 normal = new Vector2(scaledPositionDelta);
            normal.normalize();
            float velocityDot = normal.dot(speedDelta) * 0.85f;
            if (velocityDot < 0.0f) {
                Vector2 impulse = new Vector2(normal);
                impulse.scale(velocityDot);
                ufo1Velocity.add(impulse);
                ufo2Velocity.sub(impulse);
                return speedDelta.getLength2();
            }
        }
        return 0.0f;
    }

    private void checkUfoTileCollision(Ufo ufo) {
        Vector2 ufoPosition = ufo.getPosition();
        float ufoLeft = ufoPosition.x - 0.9f;
        float ufoRight = ufoLeft + 1.8f;
        float ufoBottom = ufoPosition.y - 0.45f;
        float ufoTop = ufoBottom + 0.9f;
        int tileLeft = (int)ufoLeft;
        int tileHCenter = (int)ufoPosition.x;
        int tileRight = (int)ufoRight - (ufoRight == (float)((int)ufoRight) ? 1 : 0);
        int tileBottom = (int)ufoBottom;
        int tileVCenter = (int)ufoPosition.y;
        int tileTop = (int)ufoTop - (ufoTop == (float)((int)ufoTop) ? 1 : 0);
        if (this.level.getTile(tileHCenter, tileBottom).getCollision() != Tile.Collision.NONE && this.level.getTile(tileHCenter, tileBottom + 1).getCollision() == Tile.Collision.NONE) {
            ufoPosition.y = (float)(tileBottom + 1) + 0.45f;
            this.ufoCollision(ufo, Vector2.UP);
        }
        if (this.level.getTile(tileHCenter, tileTop).getCollision() != Tile.Collision.NONE && this.level.getTile(tileHCenter, tileTop - 1).getCollision() == Tile.Collision.NONE) {
            ufoPosition.y = (float)tileTop - 0.45f;
            this.ufoCollision(ufo, Vector2.DOWN);
        }
        if (this.level.getTile(tileLeft, tileVCenter).getCollision() != Tile.Collision.NONE && this.level.getTile(tileLeft + 1, tileVCenter).getCollision() == Tile.Collision.NONE) {
            ufoPosition.x = (float)(tileLeft + 1) + 0.9f;
            this.ufoCollision(ufo, Vector2.RIGHT);
        }
        if (this.level.getTile(tileRight, tileVCenter).getCollision() != Tile.Collision.NONE && this.level.getTile(tileRight - 1, tileVCenter).getCollision() == Tile.Collision.NONE) {
            ufoPosition.x = (float)tileRight - 0.9f;
            this.ufoCollision(ufo, Vector2.LEFT);
        }
        ArrayList<Corner> corners = new ArrayList<Corner>();
        for (int y = tileBottom; y <= tileTop; ++y) {
            for (int x = tileLeft; x <= tileRight; ++x) {
                Tile tile = this.level.getTile(x, y);
                Tile.Collision collision = tile.getCollision();
                if (collision != Tile.Collision.SOLID) continue;
                boolean[][] passables = new boolean[3][3];
                for (int y1 = y - 1; y1 <= y + 1; ++y1) {
                    for (int x1 = x - 1; x1 <= x + 1; ++x1) {
                        passables[y1 - y + 1][x1 - x + 1] = x1 >= tileLeft && x1 <= tileRight && y1 >= tileBottom && y1 <= tileTop && this.level.getTile(x1, y1).getCollision() == Tile.Collision.NONE;
                    }
                }
                boolean BOTTOM = false;
                boolean VCENTER = true;
                int TOP = 2;
                boolean LEFT = false;
                boolean HCENTER = true;
                int RIGHT = 2;
                boolean bottomLeftPassable = passables[0][0];
                boolean bottomPassable = passables[0][1];
                boolean bottomRightPassable = passables[0][2];
                boolean leftPassable = passables[1][0];
                boolean rightPassable = passables[1][2];
                boolean topLeftPassable = passables[2][0];
                boolean topPassable = passables[2][1];
                boolean topRightPassable = passables[2][2];
                if (bottomLeftPassable && leftPassable && bottomPassable) {
                    corners.add(new Corner(x, y, Corner.Direction.BOTTOMLEFT));
                }
                if (bottomRightPassable && rightPassable && bottomPassable) {
                    corners.add(new Corner(x, y, Corner.Direction.BOTTOMRIGHT));
                }
                if (topLeftPassable && topPassable && leftPassable) {
                    corners.add(new Corner(x, y, Corner.Direction.TOPLEFT));
                }
                if (!topRightPassable || !topPassable || !rightPassable) continue;
                corners.add(new Corner(x, y, Corner.Direction.TOPRIGHT));
            }
        }
        for (Corner corner : corners) {
            Vector2 cornerDelta = new Vector2(corner.getX() - ufoPosition.x, corner.getY() - ufoPosition.y);
            Vector2 scaledDelta = new Vector2(cornerDelta);
            scaledDelta.divide(Ufo.RADIUS);
            float testDot = scaledDelta.getLength2();
            if (!(testDot < 1.0f)) continue;
            Vector2 move = new Vector2(cornerDelta);
            move.multiply(Ufo.RADIUS);
            move.scale(1.0f - testDot);
            ufoPosition.sub(move);
            Vector2 normal = new Vector2(scaledDelta);
            normal.scale(-1.0f);
            normal.normalize();
            this.ufoCollision(ufo, normal);
        }
    }

    private void ufoCollision(Ufo ufo, Vector2 normal) {
        Vector2 velocity = ufo.getVelocity();
        velocity.reflect(normal, 0.85f);
        float strength = Math.max(0.0f, Math.min(1.0f, velocity.dot(normal) * 10.0f));
        this.ufoCollided(ufo, strength);
    }

    protected void ufoCollided(Ufo ufo, float strength) {
    }

    private boolean checkBulletTileCollision(Bullet bullet) {
        double angle;
        boolean yBounce;
        float x = bullet.getPosition().x;
        float y = bullet.getPosition().y;
        float xVel = bullet.getVelocity().x;
        float yVel = bullet.getVelocity().y;
        int tileX = (int)x;
        int tileY = (int)y;
        if (tileX < 0 || tileY < 0 || tileX >= this.level.getWidth() || tileY >= this.level.getHeight()) {
            return true;
        }
        Tile tile = this.level.getTile(tileX, tileY);
        if (tile.getCollision() == Tile.Collision.NONE) {
            return false;
        }
        boolean xBounce = this.level.getTile((int)(x - xVel), (int)y).getCollision() == Tile.Collision.NONE;
        boolean bl = yBounce = this.level.getTile((int)x, (int)(y - yVel)).getCollision() == Tile.Collision.NONE;
        if (xBounce && !yBounce) {
            angle = Math.abs(xVel / yVel);
        } else if (yBounce && !xBounce) {
            angle = Math.abs(yVel / xVel);
        } else {
            return true;
        }
        double unlikeliness = Math.sqrt(Math.atan(angle) * 2.0 / Math.PI);
        if ((double)bullet.getBounceProbability() < unlikeliness) {
            return true;
        }
        if (xBounce) {
            bullet.getVelocity().x *= -1.0f;
        } else if (yBounce) {
            bullet.getVelocity().y *= -1.0f;
        } else assert (false);
        bullet.setBounceProbability(0.0f);
        this.bulletBounced();
        return false;
    }

    private boolean checkBulletUfoCollision(Bullet bullet, Ufo ufo) {
        int accuracy = 5;
        for (int i = 0; i < accuracy; ++i) {
            Vector2 bulletPosition = new Vector2(bullet.getPosition());
            bulletPosition.addScaled(bullet.getVelocity(), (float)i / (float)accuracy);
            Vector2 ufoPosition = ufo.getPosition();
            Vector2 positionDelta = new Vector2(bulletPosition.x - ufoPosition.x, bulletPosition.y - ufoPosition.y);
            Vector2 scaledPositionDelta = new Vector2(positionDelta);
            scaledPositionDelta.divide(Ufo.DIAMETER);
            scaledPositionDelta.scale(2.0f);
            float testDot = scaledPositionDelta.getLength2();
            if (!(testDot < 1.0f)) continue;
            ufo.getVelocity().addScaled(bullet.getVelocity(), 1.0f);
            return true;
        }
        return false;
    }

    public void addBullet(int bulletId, Bullet bullet) {
        this.bullets.put(bulletId, bullet);
    }

    public Collection<Bullet> getBullets() {
        return this.bullets.values();
    }

    public void dropPlayers(String[] players) {
        for (String player : players) {
            for (Ufo ufo : new ArrayList<Ufo>(this.ufos)) {
                if (!ufo.getPlayerName().equals(player)) continue;
                this.ufos.remove(ufo);
            }
        }
    }

    public Iterable<Ufo> getUfos() {
        return this.ufos;
    }

    private static class Corner {
        private final int x;
        private final int y;
        private final Direction direction;

        public Corner(int x, int y, Direction direction) {
            this.x = x;
            this.y = y;
            this.direction = direction;
        }

        public float getX() {
            return this.x + (this.direction == Direction.BOTTOMRIGHT || this.direction == Direction.TOPRIGHT ? 1 : 0);
        }

        public float getY() {
            return this.y + (this.direction == Direction.TOPLEFT || this.direction == Direction.TOPRIGHT ? 1 : 0);
        }

        public static enum Direction {
            BOTTOMLEFT,
            BOTTOMRIGHT,
            TOPLEFT,
            TOPRIGHT;

        }
    }
}

