/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.game;

import java.util.HashMap;
import java.util.Map;
import lonelycoders.ufohippa.game.InputAction;
import lonelycoders.ufohippa.game.PlayerAction;

public final class PlayerInputAction
extends InputAction {
    private static int currentOrdinal = 0;
    private static final Map<Integer, PlayerInputAction> actions = new HashMap<Integer, PlayerInputAction>();
    public static final PlayerInputAction PLAYER_1_LEFT = new PlayerInputAction(0, PlayerAction.LEFT);
    public static final PlayerInputAction PLAYER_1_RIGHT = new PlayerInputAction(0, PlayerAction.RIGHT);
    public static final PlayerInputAction PLAYER_1_UP = new PlayerInputAction(0, PlayerAction.UP);
    public static final PlayerInputAction PLAYER_1_DOWN = new PlayerInputAction(0, PlayerAction.DOWN);
    public static final PlayerInputAction PLAYER_1_ACTION = new PlayerInputAction(0, PlayerAction.ACTION);
    public static final PlayerInputAction PLAYER_2_LEFT = new PlayerInputAction(1, PlayerAction.LEFT);
    public static final PlayerInputAction PLAYER_2_RIGHT = new PlayerInputAction(1, PlayerAction.RIGHT);
    public static final PlayerInputAction PLAYER_2_UP = new PlayerInputAction(1, PlayerAction.UP);
    public static final PlayerInputAction PLAYER_2_DOWN = new PlayerInputAction(1, PlayerAction.DOWN);
    public static final PlayerInputAction PLAYER_2_ACTION = new PlayerInputAction(1, PlayerAction.ACTION);
    public static final PlayerInputAction PLAYER_3_LEFT = new PlayerInputAction(2, PlayerAction.LEFT);
    public static final PlayerInputAction PLAYER_3_RIGHT = new PlayerInputAction(2, PlayerAction.RIGHT);
    public static final PlayerInputAction PLAYER_3_UP = new PlayerInputAction(2, PlayerAction.UP);
    public static final PlayerInputAction PLAYER_3_DOWN = new PlayerInputAction(2, PlayerAction.DOWN);
    public static final PlayerInputAction PLAYER_3_ACTION = new PlayerInputAction(2, PlayerAction.ACTION);
    private final int playerIndex;
    private final PlayerAction action;
    private final int ordinal;

    private PlayerInputAction(int playerIndex, PlayerAction action) {
        this.playerIndex = playerIndex;
        this.action = action;
        this.ordinal = currentOrdinal++;
        actions.put(this.ordinal, this);
    }

    public int getPlayerIndex() {
        return this.playerIndex;
    }

    public PlayerAction getAction() {
        return this.action;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public static PlayerInputAction fromOrdinal(int ordinal) {
        return actions.get(ordinal);
    }

    public String toString() {
        return this.action.name() + "_" + this.playerIndex;
    }
}

