/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.states;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lonelycoders.ufohippa.client.levels.LevelManager;
import lonelycoders.ufohippa.client.lobby.model.AllMatchSettings;
import lonelycoders.ufohippa.client.sound.SoundManager;
import lonelycoders.ufohippa.client.states.ClientLobbyState;
import lonelycoders.ufohippa.client.states.match.ClientMatchStateManager;
import lonelycoders.ufohippa.network.CommandHandler;
import lonelycoders.ufohippa.network.CommandSender;
import lonelycoders.ufohippa.network.CommandState;
import lonelycoders.ufohippa.network.NetworkProtocolException;
import lonelycoders.ufohippa.network.State;
import lonelycoders.ufohippa.network.StateManager;
import lonelycoders.ufohippa.network.commands.initial.HelloCommand;

public class ClientStateManager
extends StateManager {
    private final CommandHandler helloHandler = new HelloCommand.Handler(){

        @Override
        public State process(HelloCommand payload) {
            return ClientStateManager.this.lobbyState;
        }
    };
    private final State initialState = new CommandState("Initial", this.helloHandler);
    private final ClientMatchStateManager matchState;
    private final ClientLobbyState lobbyState;

    public ClientStateManager(SoundManager soundManager, LevelManager levelManager, AllMatchSettings allMatchSettings, Object gameLock) {
        super("General state manager");
        this.matchState = new ClientMatchStateManager(soundManager, levelManager, gameLock);
        this.lobbyState = new ClientLobbyState(allMatchSettings, this.matchState);
        this.matchState.setLobbyState(this.lobbyState);
    }

    @Override
    public void connected(CommandSender commandSender) throws NetworkProtocolException {
        super.connected(commandSender);
        this.setActive(true);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.setState(this.initialState);
            this.sendCommand(new HelloCommand());
        }
    }

    @Override
    protected Set<State> getAvailableStates() {
        return new HashSet<State>(Arrays.asList(this.initialState, this.lobbyState, this.matchState));
    }

    @Override
    protected Map<State, State> getFinalStates() {
        return new HashMap<State, State>();
    }

    public ClientLobbyState getLobbyState() {
        return this.lobbyState;
    }

    public ClientMatchStateManager getMatchState() {
        return this.matchState;
    }
}

