/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.states;

import java.util.ArrayList;
import java.util.List;
import lonelycoders.ufohippa.client.lobby.model.AllMatchSettings;
import lonelycoders.ufohippa.client.lobby.model.BasicSettings;
import lonelycoders.ufohippa.client.lobby.model.PlayerInfo;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.network.CommandHandler;
import lonelycoders.ufohippa.network.CommandState;
import lonelycoders.ufohippa.network.State;
import lonelycoders.ufohippa.network.commands.lobby.AllBasicSettingsCommand;
import lonelycoders.ufohippa.network.commands.lobby.AllLevelSettingsCommand;
import lonelycoders.ufohippa.network.commands.lobby.AllPlayerSettingsCommand;
import lonelycoders.ufohippa.network.commands.lobby.ClientSendMessageCommand;
import lonelycoders.ufohippa.network.commands.lobby.PlayerSettingsCommand;
import lonelycoders.ufohippa.network.commands.lobby.PlayerSettingsCommandReply;
import lonelycoders.ufohippa.network.commands.lobby.ServerSendMessageCommand;
import lonelycoders.ufohippa.network.commands.lobby.StartGameCommand;
import lonelycoders.ufohippa.network.commands.lobby.StartGameReplyCommand;

public class ClientLobbyState
extends CommandState {
    private final List<MessageListener> messageListeners = new ArrayList<MessageListener>();
    private final List<SettingsListener> settingsListeners = new ArrayList<SettingsListener>();
    private final AllMatchSettings allMatchSettings;
    private final State matchState;
    private final CommandHandler playerSettingsReplyHandler = new PlayerSettingsCommandReply.Handler(){

        @Override
        public State process(PlayerSettingsCommandReply payload) {
            for (SettingsListener listener : ClientLobbyState.this.settingsListeners) {
                listener.clientSettingsChanged(payload.getPlayerCount(), payload.getPlayerNames(), payload.getPlayerColors());
            }
            return null;
        }
    };
    private final CommandHandler allBasicSettingsHandler = new AllBasicSettingsCommand.Handler(){

        @Override
        public State process(AllBasicSettingsCommand payload) {
            int playingTime = payload.getPlayingTime();
            int aiPlayers = payload.getAiPlayers();
            boolean bonusItems = payload.bonusItems();
            ClientLobbyState.this.allMatchSettings.setBasicSettings(new BasicSettings(playingTime, aiPlayers, bonusItems, false, false));
            return null;
        }
    };
    private final CommandHandler allPlayerSettingsHandler = new AllPlayerSettingsCommand.Handler(){

        @Override
        public State process(AllPlayerSettingsCommand payload) {
            PlayerInfo[] playerInfos = new PlayerInfo[payload.getPlayerCount()];
            for (int i = 0; i < playerInfos.length; ++i) {
                playerInfos[i] = new PlayerInfo(payload.getPlayerNames()[i], payload.getPlayerColors()[i]);
            }
            ClientLobbyState.this.allMatchSettings.setPlayers(playerInfos);
            return null;
        }
    };
    private final CommandHandler allLevelSettingsHandler = new AllLevelSettingsCommand.Handler(){

        @Override
        public State process(AllLevelSettingsCommand payload) {
            String[] levels = new String[payload.getLevelCount()];
            for (int i = 0; i < levels.length; ++i) {
                levels[i] = payload.getLevelNames()[i];
            }
            ClientLobbyState.this.allMatchSettings.setLevels(levels);
            return null;
        }
    };
    private final CommandHandler sendMessageHandler = new ServerSendMessageCommand.Handler(){

        @Override
        public State process(ServerSendMessageCommand payload) {
            for (MessageListener messageListener : ClientLobbyState.this.messageListeners) {
                messageListener.messageReceived(payload.getClientName(), payload.getMessage());
            }
            return null;
        }
    };
    private final CommandHandler startGameHandler = new StartGameCommand.Handler(){

        @Override
        public State process(StartGameCommand payload) {
            ClientLobbyState.this.sendCommand(new StartGameReplyCommand());
            return ClientLobbyState.this.matchState;
        }
    };

    public ClientLobbyState(AllMatchSettings allMatchSettings, State matchState) {
        super("Lobby", new CommandHandler[0]);
        this.allMatchSettings = allMatchSettings;
        this.matchState = matchState;
        this.registerHandlers(this.playerSettingsReplyHandler, this.allBasicSettingsHandler, this.allPlayerSettingsHandler, this.allLevelSettingsHandler, this.sendMessageHandler, this.startGameHandler);
    }

    public void addMessageListener(MessageListener listener) {
        this.messageListeners.add(listener);
    }

    public void addSettingsListener(SettingsListener listener) {
        this.settingsListeners.add(listener);
    }

    public void setClientSettings(int playerCount, String[] playerNames, ColorRGB[] playerColors) {
        this.sendCommand(new PlayerSettingsCommand(playerCount, playerNames, playerColors));
    }

    public void sendMessage(String message) {
        this.sendCommand(new ClientSendMessageCommand(message));
    }

    public static interface SettingsListener {
        public void clientSettingsChanged(int var1, String[] var2, ColorRGB[] var3);
    }

    public static interface MessageListener {
        public void messageReceived(String var1, String var2);
    }
}

