/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.sound.fmod;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import lonelycoders.ufohippa.client.sound.Sound;
import lonelycoders.ufohippa.client.sound.SoundSystem;
import lonelycoders.ufohippa.client.sound.fmod.FMOD;
import lonelycoders.ufohippa.client.sound.fmod.FMODChannel;
import lonelycoders.ufohippa.client.sound.fmod.FMODSound;
import lonelycoders.ufohippa.client.sound.fmod.FMODSystem;
import lonelycoders.ufohippa.client.sound.fmod.FmodCreateSoundExInfo;
import lonelycoders.ufohippa.client.sound.fmod.FmodException;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.util.ResourceUtil;

public class FmodSoundSystem
implements SoundSystem {
    private final FMOD fmod;
    private final FMODSystem system;
    private final Timer timer;
    private final Properties masterVolumes;
    private boolean destroyed;
    private final ArrayList<SoundImpl> loadedSounds = new ArrayList();

    public FmodSoundSystem() {
        this.fmod = (FMOD)Native.loadLibrary("fmodex", FMOD.class);
        PointerByReference pref = new PointerByReference();
        FmodException.check(this.fmod.FMOD_System_Create(pref));
        this.system = new FMODSystem();
        this.system.setPointer(pref.getValue());
        FmodException.check(this.fmod.FMOD_System_Init(this.system, 100, 0, Pointer.NULL));
        this.timer = new Timer("FMOD timer");
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                FmodSoundSystem.this.update();
            }
        }, 0L, 1000L);
        this.masterVolumes = new Properties();
        try {
            this.masterVolumes.load(ResourceUtil.getResource("soundconfig.properties"));
        }
        catch (IOException e) {
            Logger.exception(e);
        }
    }

    @Override
    public synchronized void shutdown() {
        this.destroyed = true;
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            Logger.exception(e);
        }
    }

    private synchronized void update() {
        FmodException.check(this.fmod.FMOD_System_Update(this.system));
        if (this.destroyed) {
            this.timer.cancel();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Logger.exception(e);
            }
            for (SoundImpl sound : this.loadedSounds) {
                sound.release();
            }
            FmodException.check(this.fmod.FMOD_System_Release(this.system));
            this.system.setPointer(null);
            this.notify();
        }
    }

    private float getMasterVolume(String name) {
        float masterVolume = Float.parseFloat(this.masterVolumes.getProperty(name, "1.0"));
        return masterVolume;
    }

    @Override
    public synchronized Sound loadStream(File soundFile, boolean loop) {
        Logger.detail("Loading stream " + soundFile.getPath());
        PointerByReference pref = new PointerByReference();
        int flags = 128;
        if (loop) {
            flags |= 2;
        }
        FmodException.check(this.fmod.FMOD_System_CreateStream(this.system, soundFile.getPath(), flags, Pointer.NULL, pref));
        SoundImpl sound = new SoundImpl(pref, soundFile.getName());
        this.loadedSounds.add(sound);
        return sound;
    }

    @Override
    public synchronized Sound loadSample(String soundResourceName) {
        byte[] bytes = ResourceUtil.getResourceBytes(soundResourceName);
        try {
            Logger.detail("Loading sample " + soundResourceName + " from resource");
            PointerByReference pref = new PointerByReference();
            FmodCreateSoundExInfo.ByReference exInfo = new FmodCreateSoundExInfo.ByReference();
            exInfo.length = bytes.length;
            FmodException.check(this.fmod.FMOD_System_CreateSound(this.system, bytes, 2304, exInfo, pref));
            SoundImpl sound = new SoundImpl(pref, soundResourceName);
            this.loadedSounds.add(sound);
            return sound;
        }
        catch (FmodException e) {
            String suffix = soundResourceName.substring(soundResourceName.lastIndexOf(46));
            try {
                File soundFile = File.createTempFile(soundResourceName.replace("/", "_"), suffix);
                soundFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(soundFile);
                fos.write(bytes);
                fos.close();
                Logger.detail("Loading sample " + soundResourceName + " from temp file " + soundFile.getPath());
                PointerByReference pref = new PointerByReference();
                FmodException.check(this.fmod.FMOD_System_CreateSound(this.system, soundFile.getPath(), 256, Pointer.NULL, pref));
                SoundImpl sound = new SoundImpl(pref, soundResourceName);
                this.loadedSounds.add(sound);
                return sound;
            }
            catch (IOException e1) {
                throw e;
            }
        }
    }

    private synchronized void release(FMODSound fmodSound) {
        FmodException.check(this.fmod.FMOD_Sound_Release(fmodSound));
    }

    private synchronized FMODChannel play(FMODSound fmodSound) {
        PointerByReference pref = new PointerByReference();
        FmodException.check(this.fmod.FMOD_System_PlaySound(this.system, -1, fmodSound, false, pref));
        FMODChannel fmodChannel = new FMODChannel();
        fmodChannel.setPointer(pref.getValue());
        return fmodChannel;
    }

    private synchronized void setVolume(FMODChannel channel, float volume) {
        FmodException.check(this.fmod.FMOD_Channel_SetVolume(channel, volume));
    }

    private void stop(FMODChannel channel) {
        FmodException.check(this.fmod.FMOD_Channel_Stop(channel));
    }

    private class SoundImpl
    implements Sound {
        private final float masterVolume;
        private final FMODSound fmodSound;
        private final String name;
        private FMODChannel channel;

        public SoundImpl(PointerByReference pref, String name) {
            this.name = name;
            this.masterVolume = FmodSoundSystem.this.getMasterVolume(name);
            this.fmodSound = new FMODSound();
            this.fmodSound.setPointer(pref.getValue());
        }

        public void release() {
            FmodSoundSystem.this.release(this.fmodSound);
        }

        @Override
        public void play() {
            this.channel = FmodSoundSystem.this.play(this.fmodSound);
            this.setVolume(this.masterVolume);
        }

        @Override
        public void stop() {
            if (this.channel != null) {
                FmodSoundSystem.this.stop(this.channel);
                this.channel = null;
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setVolume(float volume) {
            if (this.channel != null) {
                FmodSoundSystem.this.setVolume(this.channel, volume);
            }
        }
    }
}

