/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.resource;

import java.util.HashMap;
import java.util.Map;
import lonelycoders.ufohippa.client.resource.DelayedResourceLoader;
import lonelycoders.ufohippa.client.resource.ResourceCreator;
import lonelycoders.ufohippa.client.resource.ResourceGL;
import lonelycoders.ufohippa.client.resource.ResourceKey;

public class ResourceManager {
    private final DelayedResourceLoader resourceLoader = new DelayedResourceLoader();
    private final Map<ResourceKey, ResourceGL> resources = new HashMap<ResourceKey, ResourceGL>();

    public <T extends ResourceGL> void addResource(ResourceKey<T> key, T resource) {
        if (this.resources.containsKey(key)) {
            throw new IllegalArgumentException("Trying to add resource with duplicate key: " + key.getKey());
        }
        this.resources.put(key, this.resourceLoader.enqueue(resource));
    }

    public <T extends ResourceGL> T addResource(ResourceKey<T> key, ResourceCreator<T> creator) {
        T resource;
        if (!this.resources.containsKey(key)) {
            resource = creator.create();
            this.resources.put(key, (ResourceGL)this.resourceLoader.enqueue(resource));
        } else {
            resource = this.getResource(key);
        }
        return resource;
    }

    public <T extends ResourceGL> T getResource(ResourceKey<T> key) {
        if (!this.resources.containsKey(key)) {
            throw new IllegalArgumentException("Trying to get resource with nonexistent key: " + key.getKey());
        }
        return (T)this.resources.get(key);
    }

    public DelayedResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void clear() {
        this.resources.clear();
    }
}

