/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl;

import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;
import javax.media.opengl.GLDrawable;
import lonelycoders.ufohippa.client.Match;
import lonelycoders.ufohippa.client.gl.GLException;
import lonelycoders.ufohippa.client.gl.GeneralResources;
import lonelycoders.ufohippa.client.gl.RenderPass;
import lonelycoders.ufohippa.client.gl.RenderTarget;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.gl.UtilGL;
import lonelycoders.ufohippa.client.gl.texturing.ImageTexture;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.client.renderer.AnimationTimer;
import lonelycoders.ufohippa.client.resource.ResourceCreator;
import lonelycoders.ufohippa.client.resource.ResourceKey;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.game.util.ColorRGB;

public class WaitingScreenRenderer
extends RenderPass {
    private static final Font TITLE_FONT = new Font("SansSerif", 1, 72);
    private final TextRenderer titleFontRenderer = new TextRenderer(TITLE_FONT, true, true);
    private final GLDrawable glPanel;
    private final AnimationTimer animationTimer;
    private final Shader backgroundShader;
    private final Texture backgroundTexture;
    private final Texture tunnelTexture;

    public WaitingScreenRenderer(RenderTarget target, GLDrawable glPanel, ResourceManager resourceManager, AnimationTimer animationTimer) {
        super(target);
        this.glPanel = glPanel;
        this.animationTimer = animationTimer;
        this.backgroundShader = resourceManager.addResource(new ResourceKey("Waiting screen shader"), new ResourceCreator<Shader>(){

            @Override
            public Shader create() {
                return new Shader("shaders/waiting");
            }
        });
        this.backgroundTexture = resourceManager.getResource(GeneralResources.TEXTURE_CIRCLE32);
        this.tunnelTexture = resourceManager.addResource(new ResourceKey("Waiting effect texture"), new ResourceCreator<Texture>(){

            @Override
            public Texture create() {
                return new ImageTexture("Waiting.png");
            }
        });
    }

    public void initialize(Match match) {
    }

    @Override
    protected void doRender(GL gl) throws GLException {
        this.startFrame(gl);
        int width = this.glPanel.getWidth();
        int height = this.glPanel.getHeight();
        this.setup2D(gl);
        this.drawBackground(gl, width, height);
        this.drawWaitingText(width, height);
        this.endFrame();
    }

    private void startFrame(GL gl) throws GLException {
        gl.glClear(256);
        UtilGL.checkErrors(gl);
    }

    private void setup2D(GL gl) {
        gl.glDisable(2896);
        gl.glDisable(2929);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    private void drawBackground(GL gl, int width, int height) {
        this.backgroundShader.bind(gl);
        this.backgroundShader.applyUniform(gl, "uTimer", this.animationTimer.getTime());
        this.backgroundShader.applyUniform(gl, "uColor1", new ColorRGB(0.3f, 0.3f, 0.3f));
        this.backgroundShader.applyUniform(gl, "uColor2", new ColorRGB(0.28f, 0.28f, 0.28f));
        this.backgroundTexture.bind(gl, this.backgroundShader, "uTexture");
        this.tunnelTexture.bind(gl, this.backgroundShader, "uTunnelTexture", 2);
        gl.glColor3f(1.0f, 1.0f, 1.0f);
        gl.glBegin(7);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glMultiTexCoord2f(33985, 0.0f, 0.0f);
        gl.glVertex2f(-1.0f, -1.0f);
        gl.glTexCoord2f(width / 32, 0.0f);
        gl.glMultiTexCoord2f(33985, 1.0f, 0.0f);
        gl.glVertex2f(1.0f, -1.0f);
        gl.glTexCoord2f(width / 32, height / 32);
        gl.glMultiTexCoord2f(33985, 1.0f, 1.0f);
        gl.glVertex2f(1.0f, 1.0f);
        gl.glTexCoord2f(0.0f, height / 32);
        gl.glMultiTexCoord2f(33985, 0.0f, 1.0f);
        gl.glVertex2f(-1.0f, 1.0f);
        gl.glEnd();
        this.tunnelTexture.unbind(gl, 2);
        this.backgroundTexture.unbind(gl);
        this.backgroundShader.unbind(gl);
    }

    private void drawWaitingText(int width, int height) {
        String text = "Waiting";
        TextRenderer renderer = this.titleFontRenderer;
        Rectangle2D loadingBounds = renderer.getBounds(text);
        renderer.beginRendering(width, height);
        renderer.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        renderer.draw(text, (int)((double)width - loadingBounds.getWidth()) / 2, height - 50 - (int)loadingBounds.getHeight());
        renderer.endRendering();
    }

    private void endFrame() {
    }
}

