/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl;

import java.awt.Color;
import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.gl.UtilGL;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.client.renderer.AnimationTimer;
import lonelycoders.ufohippa.client.renderer.gl.BackgroundEffect;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.game.util.Vector3;

public class StarFieldEffect
implements BackgroundEffect {
    private static final int STAR_COUNT = 1000;
    private static final float MAX_DISTANCE = 10.0f;
    private static final float SPEED = 0.1f;
    private final Star[] stars = new Star[1000];
    private final Texture flareTexture;
    private final AnimationTimer animationTimer;
    private double lastTime;
    private int levelWidth;
    private int levelHeight;

    public StarFieldEffect(Texture flareTexture, AnimationTimer animationTimer) {
        this.flareTexture = flareTexture;
        this.animationTimer = animationTimer;
        for (int i = 0; i < this.stars.length; ++i) {
            this.stars[i] = new Star();
        }
    }

    @Override
    public void initialize(int levelWidth, int levelHeight) {
        this.levelWidth = levelWidth;
        this.levelHeight = levelHeight;
        for (Star star : this.stars) {
            star.initialize(levelWidth, levelHeight, true);
        }
        this.lastTime = -1.0;
    }

    @Override
    public void render(GL gl, int levelWidth, int levelHeight) {
        this.levelWidth = levelWidth;
        this.levelHeight = levelHeight;
        double newTime = this.animationTimer.getTime();
        if (this.lastTime != -1.0) {
            this.update((float)(newTime - this.lastTime));
        }
        this.lastTime = newTime;
        gl.glDepthMask(false);
        gl.glDisable(2896);
        UtilGL.enableBlend(gl, UtilGL.BlendMode.ADDITIVE);
        this.flareTexture.bind(gl);
        for (Star star : this.stars) {
            ColorRGB color = star.color.blend(Math.min(1.0f, 2.0f * (1.0f - ((Star)star).position.z / 10.0f)));
            UtilGL.applyColor(gl, color);
            float scale = 1.0f / ((Star)star).position.z;
            float x = ((Star)star).position.x * scale + (float)this.levelWidth * 0.5f;
            float y = ((Star)star).position.y * scale + (float)this.levelHeight * 0.5f;
            float size = scale * star.size;
            UtilGL.drawSquare(gl, x, y, -1.0f, size);
        }
        this.flareTexture.unbind(gl);
        UtilGL.disableBlend(gl);
        gl.glDepthMask(true);
    }

    private void update(float deltaTime) {
        for (Star star : this.stars) {
            ((Star)star).position.z -= deltaTime * 0.1f;
            if (!(((Star)star).position.z <= 0.0f)) continue;
            star.initialize(this.levelWidth, this.levelHeight, false);
        }
    }

    private static class Star {
        private final Vector3 position = new Vector3(0.0f, 0.0f, 0.0f);
        private float size;
        private ColorRGB color;

        private Star() {
        }

        public void initialize(int levelWidth, int levelHeight, boolean first) {
            this.position.x = (float)(Math.random() - 0.5) * (float)levelWidth * 10.0f;
            this.position.y = (float)(Math.random() - 0.5) * (float)levelHeight * 10.0f;
            this.position.z = (float)(Math.random() * 10.0);
            if (!first) {
                this.position.z = this.position.z * 0.2f + 10.0f;
            }
            this.size = (float)Math.random() * 0.5f + 0.5f;
            this.color = new ColorRGB(Color.getHSBColor((float)Math.random(), 0.1f, 0.7f));
        }
    }
}

