/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.gl.RenderOptimizer;
import lonelycoders.ufohippa.client.gl.UtilGL;
import lonelycoders.ufohippa.client.renderer.gl.Renderable;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.client.resource.TileResource;
import lonelycoders.ufohippa.game.level.Tile;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.game.util.Vector3;
import lonelycoders.ufohippa.general.Logger;

public class ModelTileResource
implements TileResource {
    private final Renderable target;

    public ModelTileResource(ResourceManager resourceManager, Tile tile) {
        Renderable target = null;
        try {
            Class<?> modelClass = Class.forName(tile.getModelClass());
            Constructor<?> constructor = modelClass.getConstructor(ResourceManager.class);
            target = (Renderable)constructor.newInstance(resourceManager);
        }
        catch (ClassNotFoundException e) {
            Logger.warning("Unable to load tile class " + tile.getModelClass());
        }
        catch (NoSuchMethodException e) {
            Logger.exception(e);
        }
        catch (InvocationTargetException e) {
            Logger.exception(e.getCause());
        }
        catch (InstantiationException e) {
            Logger.exception(e);
        }
        catch (IllegalAccessException e) {
            Logger.exception(e);
        }
        this.target = target;
    }

    @Override
    public void render(GL gl, ColorRGB color) {
        ColorRGB renderColor = ColorRGB.GRAY;
        if (color != null) {
            renderColor = renderColor.multiply(color);
        }
        UtilGL.applyColor(gl, renderColor);
        if (this.target != null) {
            this.target.render(gl);
        }
    }

    @Override
    public void render(RenderOptimizer renderOptimizer, Vector3 offset, ColorRGB color) {
        ColorRGB renderColor = ColorRGB.GRAY;
        if (color != null) {
            renderColor = renderColor.multiply(color);
        }
        renderOptimizer.setColor(renderColor);
        if (this.target != null) {
            this.target.render(renderOptimizer, offset);
        }
    }
}

