/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl;

import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;
import javax.media.opengl.GLDrawable;
import lonelycoders.ufohippa.client.Match;
import lonelycoders.ufohippa.client.gl.GLException;
import lonelycoders.ufohippa.client.gl.RenderPass;
import lonelycoders.ufohippa.client.renderer.AnimationTimer;
import lonelycoders.ufohippa.client.renderer.gl.GameRenderer;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.game.Round;
import lonelycoders.ufohippa.game.level.Level;

public class MatchRenderer
extends RenderPass {
    private static final Font SMALL_FONT = new Font("SansSerif", 1, 24);
    private final TextRenderer timeTextRenderer = new TextRenderer(SMALL_FONT, true, true);
    private final GLDrawable glPanel;
    private final GameRenderer gameRenderer;
    private Match match;
    private Round currentRound;

    public MatchRenderer(GLDrawable glPanel, ResourceManager resourceManager, AnimationTimer animationTimer) {
        this.glPanel = glPanel;
        this.gameRenderer = new GameRenderer(glPanel, resourceManager, animationTimer);
    }

    public void loadMatch(Match match) {
        this.match = match;
        for (Level level : match.getLevels()) {
            this.gameRenderer.loadTiles(level);
        }
    }

    @Override
    protected void doRender(GL gl) throws GLException {
        Round currentRound = this.match.getCurrentRound();
        if (this.currentRound != currentRound) {
            this.currentRound = currentRound;
            this.gameRenderer.loadRound(currentRound);
        }
        this.gameRenderer.render(gl);
        this.renderTime(currentRound);
    }

    private void renderTime(Round currentRound) {
        int seconds = currentRound.getRemainingSeconds();
        int minutes = seconds / 60;
        String text = String.format("%2d:%02d", minutes, seconds %= 60);
        TextRenderer renderer = this.timeTextRenderer;
        Rectangle2D bounds = renderer.getBounds(text);
        int width = this.glPanel.getWidth();
        int height = this.glPanel.getHeight();
        renderer.beginRendering(width, height);
        renderer.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        renderer.draw(text, (int)((double)width - bounds.getWidth()) / 2, height - 10 - (int)bounds.getHeight());
        renderer.endRendering();
    }
}

