/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.renderer.gl;

import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.gl.GameResources;
import lonelycoders.ufohippa.client.gl.MeshGL;
import lonelycoders.ufohippa.client.gl.RenderOptimizer;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.gl.UtilGL;
import lonelycoders.ufohippa.client.gl.texturing.ImageTexture;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.client.resource.ResourceCreator;
import lonelycoders.ufohippa.client.resource.ResourceKey;
import lonelycoders.ufohippa.client.resource.ResourceManager;
import lonelycoders.ufohippa.client.resource.TileResource;
import lonelycoders.ufohippa.game.level.Tile;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.game.util.Vector3;

public class BackgroundTileResource
implements TileResource {
    private final Texture texture;
    private final Shader phongShader;
    private final MeshGL tileQuad;

    public BackgroundTileResource(ResourceManager resourceManager, Tile tile) {
        this.phongShader = resourceManager.getResource(GameResources.SHADER_PHONG_MULTILIGHT);
        this.tileQuad = resourceManager.getResource(GameResources.TILE_QUAD);
        final String imageName = tile.getImage2dName();
        this.texture = resourceManager.addResource(new ResourceKey("Tile 2D image " + imageName), new ResourceCreator<Texture>(){

            @Override
            public Texture create() {
                return new ImageTexture(imageName);
            }
        });
    }

    @Override
    public void render(GL gl, ColorRGB color) {
        this.phongShader.applyUniform(gl, "ufoFactor", 3.0f);
        this.texture.bind(gl, this.phongShader, "texture");
        ColorRGB renderColor = TileResource.color;
        if (color != null) {
            renderColor = renderColor.multiply(color);
        }
        UtilGL.applyColor(gl, renderColor);
        this.tileQuad.render(gl);
        this.texture.unbind(gl);
        this.phongShader.applyUniform(gl, "ufoFactor", 0.0f);
    }

    @Override
    public void render(RenderOptimizer renderOptimizer, Vector3 offset, ColorRGB color) {
        renderOptimizer.applyUniform(this.phongShader, "ufoFactor", 3.0f);
        renderOptimizer.bindTexture(this.texture, this.phongShader, "texture");
        ColorRGB renderColor = TileResource.color;
        if (color != null) {
            renderColor = renderColor.multiply(color);
        }
        renderOptimizer.setColor(renderColor);
        renderOptimizer.drawMesh(this.tileQuad, offset);
        renderOptimizer.unbindTexture(this.texture);
        renderOptimizer.applyUniform(this.phongShader, "ufoFactor", 0.0f);
    }
}

