/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.lobby.model;

import java.util.Collection;
import java.util.HashSet;
import lonelycoders.ufohippa.client.lobby.model.PlayerInfo;
import lonelycoders.ufohippa.game.util.ColorRGB;

public class PlayerSettingsModel {
    private int playerCount = 1;
    private final PlayerInfo[] playerInfos = new PlayerInfo[]{new PlayerInfo("Player 1", ColorRGB.RED), new PlayerInfo("Player 2", ColorRGB.GREEN), new PlayerInfo("Player 3", ColorRGB.BLUE)};
    private final Collection<Listener> listeners = new HashSet<Listener>();

    public void setPlayerCount(int playerCount, boolean notify) {
        if (this.playerCount != (playerCount = Math.max(1, Math.min(3, playerCount)))) {
            this.playerCount = playerCount;
            if (notify) {
                this.firePlayerInfoChanged();
            }
        }
    }

    public void setPlayerName(int playerIndex, String name, boolean notify) {
        PlayerInfo oldPlayerInfo = this.playerInfos[playerIndex];
        PlayerInfo newPlayerInfo = new PlayerInfo(name, oldPlayerInfo.getColor());
        if (!newPlayerInfo.equals(oldPlayerInfo)) {
            this.playerInfos[playerIndex] = newPlayerInfo;
            if (notify) {
                this.firePlayerInfoChanged();
            }
        }
    }

    public void setPlayerColor(int playerIndex, ColorRGB color, boolean notify) {
        PlayerInfo oldPlayerInfo = this.playerInfos[playerIndex];
        PlayerInfo newPlayerInfo = new PlayerInfo(oldPlayerInfo.getName(), color);
        if (!newPlayerInfo.equals(oldPlayerInfo)) {
            this.playerInfos[playerIndex] = newPlayerInfo;
            if (notify) {
                this.firePlayerInfoChanged();
            }
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
        this.firePlayerInfoChanged(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void firePlayerInfoChanged() {
        for (Listener listener : this.listeners) {
            this.firePlayerInfoChanged(listener);
        }
    }

    private void firePlayerInfoChanged(Listener listener) {
        String[] playerNames = new String[this.playerCount];
        ColorRGB[] playerColors = new ColorRGB[this.playerCount];
        for (int i = 0; i < this.playerCount; ++i) {
            playerNames[i] = this.playerInfos[i].getName();
            playerColors[i] = this.playerInfos[i].getColor();
        }
        listener.playersChanged(this.playerCount, playerNames, playerColors);
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    public String[] getPlayerNames() {
        String[] names = new String[this.playerCount];
        for (int i = 0; i < this.playerCount; ++i) {
            names[i] = this.playerInfos[i].getName();
        }
        return names;
    }

    public ColorRGB[] getPlayerColors() {
        ColorRGB[] colors = new ColorRGB[this.playerCount];
        for (int i = 0; i < this.playerCount; ++i) {
            colors[i] = this.playerInfos[i].getColor();
        }
        return colors;
    }

    public static interface Listener {
        public void playersChanged(int var1, String[] var2, ColorRGB[] var3);
    }
}

