/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.lobby.gui;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lonelycoders.ufohippa.client.ApplicationFrame;
import lonelycoders.ufohippa.client.Client;
import lonelycoders.ufohippa.client.levels.LevelManager;
import lonelycoders.ufohippa.client.lobby.gui.AllPlayersPanel;
import lonelycoders.ufohippa.client.lobby.gui.ClientChangeListener;
import lonelycoders.ufohippa.client.lobby.gui.ClientSettingsManager;
import lonelycoders.ufohippa.client.lobby.gui.ConnectPanel;
import lonelycoders.ufohippa.client.lobby.gui.LobbyMode;
import lonelycoders.ufohippa.client.lobby.gui.MessagePanel;
import lonelycoders.ufohippa.client.lobby.gui.PlayersPanel;
import lonelycoders.ufohippa.client.lobby.model.AllMatchSettings;
import lonelycoders.ufohippa.client.lobby.model.PlayerSettingsModel;
import lonelycoders.ufohippa.client.sound.SoundManager;
import lonelycoders.ufohippa.client.states.ClientLobbyState;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.general.Logger;

public class JoinGamePanel
extends JPanel
implements LobbyMode,
ClientSettingsManager {
    private final PlayerSettingsModel playerSettings = new PlayerSettingsModel();
    private final Collection<ClientChangeListener> listeners = new HashSet<ClientChangeListener>();
    private final ApplicationFrame applicationFrame;
    private final SoundManager soundManager;
    private final LevelManager levelManager;
    private final Object gameLock;
    private final MessagePanel messagePanel;
    private final ConnectPanel connectPanel;
    private Client client;

    public JoinGamePanel(ApplicationFrame applicationFrame, Object gameLock, SoundManager soundManager, LevelManager levelManager, final Runnable backCommand) {
        this.applicationFrame = applicationFrame;
        this.gameLock = gameLock;
        this.soundManager = soundManager;
        this.levelManager = levelManager;
        this.setOpaque(false);
        int MARGIN = 10;
        double[] columns = new double[]{MARGIN, -1.0, MARGIN};
        double[] rows = new double[]{MARGIN, -1.0, MARGIN, -2.0, MARGIN};
        TableLayout layout = new TableLayout(columns, rows);
        this.setLayout(layout);
        double[] settingsColumns = new double[]{-2.0, -1.0};
        double[] settingsRows = new double[]{-2.0, -2.0, -1.0};
        TableLayout settingsLayout = new TableLayout(settingsColumns, settingsRows);
        settingsLayout.setHGap(0);
        settingsLayout.setVGap(0);
        JPanel settingsPanel = new JPanel(settingsLayout);
        settingsPanel.setOpaque(false);
        try {
            String computerName = InetAddress.getLocalHost().getHostName();
            this.playerSettings.setPlayerName(0, computerName, true);
            this.playerSettings.setPlayerName(1, computerName + " 2", true);
            this.playerSettings.setPlayerName(2, computerName + " 3", true);
        }
        catch (UnknownHostException e) {
            Logger.exception(e);
        }
        PlayersPanel playerPanel = new PlayersPanel("Players", this.playerSettings, false);
        settingsPanel.add((Component)playerPanel, "0, 0, 0, 1, f, f");
        ConnectPanel.ConnectHandler connectHandler = new ConnectPanel.ConnectHandler(){

            @Override
            public void connect(String address, int port) {
                JoinGamePanel.this.connect(address, port);
            }

            @Override
            public void disconnect() {
                JoinGamePanel.this.disconnect();
            }
        };
        this.connectPanel = new ConnectPanel("Connect to server", connectHandler);
        settingsPanel.add((Component)this.connectPanel, "1, 0, f, f");
        AllPlayersPanel allPlayersPanel = new AllPlayersPanel(this, 6);
        settingsPanel.add((Component)allPlayersPanel, "1, 1, f, f");
        MessagePanel.MessageSender messageSender = new MessagePanel.MessageSender(){

            @Override
            public void sendMessage(String message) {
                JoinGamePanel.this.sendMessage(message);
            }
        };
        this.messagePanel = new MessagePanel(messageSender);
        settingsPanel.add((Component)this.messagePanel, "0, 2, 1, 2, f, f");
        this.add((Component)settingsPanel, "1, 1, f, f");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        buttonsPanel.setOpaque(false);
        JButton backButton = new JButton("Back to menu");
        buttonsPanel.add(backButton);
        backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result;
                boolean back = true;
                if (JoinGamePanel.this.client != null && (result = JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent(JoinGamePanel.this), "You are currently connected to a game.\nLeaving will disconnect.", "Confirm disconnect", 2)) != 0) {
                    back = false;
                    Logger.info("Not leaving join game");
                }
                if (back) {
                    JoinGamePanel.this.disconnect();
                    Logger.info("Leaving join game");
                    backCommand.run();
                }
            }
        });
        this.add((Component)buttonsPanel, "1, 3, c, c");
        this.playerSettings.addListener(new PlayerSettingsModel.Listener(){

            @Override
            public void playersChanged(int newPlayerCount, String[] newNames, ColorRGB[] newColors) {
                JoinGamePanel.this.updateClientSettings();
            }
        });
    }

    private void sendMessage(String message) {
        if (this.client != null) {
            ClientLobbyState lobbyState = this.client.getManager().getLobbyState();
            lobbyState.sendMessage(message);
        }
    }

    private void connect(final String address, final int port) {
        this.connectPanel.setState(ConnectPanel.ConnectState.CONNECTING);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Client client;
                try {
                    client = new Client(JoinGamePanel.this.soundManager, JoinGamePanel.this.levelManager, "GUI client", JoinGamePanel.this.gameLock, JoinGamePanel.this.applicationFrame);
                    client.connect(InetAddress.getByName(address), port);
                    JoinGamePanel.this.client = client;
                    JoinGamePanel.this.connectPanel.setState(ConnectPanel.ConnectState.CONNECTED);
                }
                catch (IOException e) {
                    Logger.exception(e);
                    JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(JoinGamePanel.this), "Failed to connect host " + address + ":" + port + "\n", "Connection failed", 1);
                    JoinGamePanel.this.connectPanel.setState(ConnectPanel.ConnectState.DISCONNECTED);
                    return;
                }
                JoinGamePanel.this.messagePanel.addMessage("Connected to " + address + ":" + port);
                client.getManager().getLobbyState().addMessageListener(new ClientLobbyState.MessageListener(){

                    @Override
                    public void messageReceived(String clientName, String message) {
                        JoinGamePanel.this.messagePanel.addMessage(clientName, message);
                    }
                });
                JoinGamePanel.this.applicationFrame.registerClient(client);
                JoinGamePanel.this.fireClientChanged();
                client.getManager().getLobbyState().addSettingsListener(new ClientLobbyState.SettingsListener(){

                    @Override
                    public void clientSettingsChanged(int playerCount, String[] playerNames, ColorRGB[] playerColors) {
                        JoinGamePanel.this.playerSettings.setPlayerCount(playerCount, true);
                        for (int i = 0; i < playerCount; ++i) {
                            JoinGamePanel.this.playerSettings.setPlayerName(i, playerNames[i], true);
                            JoinGamePanel.this.playerSettings.setPlayerColor(i, playerColors[i], true);
                        }
                    }
                });
                JoinGamePanel.this.updateClientSettings();
            }
        });
    }

    private void disconnect() {
        if (this.client != null) {
            this.applicationFrame.unregisterClient(this.client);
            this.client.disconnect();
        }
        this.client = null;
        this.fireClientChanged();
        this.connectPanel.setState(ConnectPanel.ConnectState.DISCONNECTED);
        this.messagePanel.reset();
    }

    @Override
    public void activate() {
        Logger.info("Activating join game");
    }

    public void reset() {
        this.messagePanel.reset();
        this.disconnect();
    }

    private void fireClientChanged() {
        for (ClientChangeListener listener : this.listeners) {
            AllMatchSettings allMatchSettings = this.client == null ? null : this.client.getAllMatchSettings();
            listener.clientChanged(allMatchSettings);
        }
    }

    private void updateClientSettings() {
        if (this.client != null) {
            ClientLobbyState lobbyState = this.client.getManager().getLobbyState();
            lobbyState.setClientSettings(this.playerSettings.getPlayerCount(), this.playerSettings.getPlayerNames(), this.playerSettings.getPlayerColors());
        }
    }

    @Override
    public void addClientChangeListener(ClientChangeListener listener) {
        this.listeners.add(listener);
        AllMatchSettings allMatchSettings = this.client == null ? null : this.client.getAllMatchSettings();
        listener.clientChanged(allMatchSettings);
    }

    @Override
    public void removeClientChangeListener(ClientChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(new Color(255, 255, 255, 127));
        Rectangle clip = g.getClipBounds();
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
    }
}

