/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.lobby.gui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import lonelycoders.ufohippa.client.lobby.gui.TitledPanel;

public class ConnectPanel
extends TitledPanel {
    private final JComboBox addressField;
    private final JButton connectButton;
    private final JComboBox portField;
    private ConnectState state;

    public ConnectPanel(String title, final ConnectHandler connectHandler) {
        super(title);
        this.setOpaque(false);
        TableLayout layout = new TableLayout(new double[]{5.0, -2.0, 5.0, -1.0, 5.0, -2.0, 5.0}, new double[]{-2.0, 5.0, -2.0});
        this.setLayout(layout);
        this.add((Component)new JLabel("Address:"), "1, 0");
        this.addressField = new JComboBox();
        this.addressField.setEditable(true);
        this.addressField.setSelectedItem("");
        this.add((Component)this.addressField, "3, 0, f, c");
        this.portField = new JComboBox();
        this.portField.setPrototypeDisplayValue("88888");
        this.portField.setMaximumSize(this.portField.getPreferredSize());
        this.portField.setEditable(true);
        this.portField.setSelectedItem(String.valueOf(13579));
        this.add((Component)this.portField, "5, 0, l, c");
        this.connectButton = new JButton("Connect");
        this.add((Component)this.connectButton, "1, 2, 5, 2, c, c");
        this.addressField.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ConnectPanel.this.connectButton.doClick();
                }
            }
        });
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConnectPanel.this.state == ConnectState.DISCONNECTED) {
                    connectHandler.connect((String)ConnectPanel.this.addressField.getSelectedItem(), Integer.parseInt((String)ConnectPanel.this.portField.getSelectedItem()));
                } else if (ConnectPanel.this.state == ConnectState.CONNECTED) {
                    connectHandler.disconnect();
                }
            }
        });
        this.setState(ConnectState.DISCONNECTED);
    }

    public void setState(ConnectState state) {
        this.state = state;
        switch (state) {
            case DISCONNECTED: {
                this.connectButton.setText("Connect");
                this.connectButton.setEnabled(true);
                this.addressField.setEnabled(true);
                this.portField.setEnabled(true);
                break;
            }
            case CONNECTING: {
                this.connectButton.setEnabled(false);
                this.addressField.setEnabled(false);
                this.portField.setEnabled(false);
                break;
            }
            case CONNECTED: {
                this.connectButton.setText("Disconnect");
                this.connectButton.setEnabled(true);
                this.addressField.setEnabled(false);
                this.portField.setEnabled(false);
            }
        }
    }

    public static enum ConnectState {
        CONNECTED,
        DISCONNECTED,
        CONNECTING;

    }

    public static interface ConnectHandler {
        public void connect(String var1, int var2);

        public void disconnect();
    }
}

