/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.lobby.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lonelycoders.ufohippa.game.util.ColorRGB;

public class ColorPanel
extends JPanel {
    private ColorRGB color = null;
    private final Collection<Listener> listeners = new HashSet<Listener>();

    public ColorPanel() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Color awtColor = JColorChooser.showDialog(SwingUtilities.windowForComponent(ColorPanel.this), "Choose player color", ColorPanel.this.color.toAwtColor());
                if (awtColor != null) {
                    ColorRGB color = new ColorRGB(awtColor);
                    ColorPanel.this.setColor(color);
                    ColorPanel.this.fireColorChanged(color);
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(10, 10);
    }

    public void setColor(ColorRGB color) {
        this.color = color;
        if (color == null) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(color.toAwtColor());
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
        if (this.color != null) {
            listener.colorChanged(this.color);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void fireColorChanged(ColorRGB newColor) {
        for (Listener listener : this.listeners) {
            listener.colorChanged(newColor);
        }
    }

    public static interface Listener {
        public void colorChanged(ColorRGB var1);
    }
}

