/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.gl.texturing;

import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.resource.ResourceGL;

public abstract class Texture
implements ResourceGL {
    protected final Type type;
    protected int id = -1;

    public Texture(Type type) {
        this.type = type;
    }

    @Override
    public void loadGl(GL gl) {
        int[] temp = new int[1];
        gl.glGenTextures(1, temp, 0);
        this.id = temp[0];
    }

    public void bind(GL gl) {
        this.bind(gl, 0);
    }

    public void bind(GL gl, int textureUnit) {
        assert (this.id != -1);
        if (textureUnit != 0) {
            gl.glActiveTexture(33984 + textureUnit);
        }
        switch (this.type) {
            case TYPE_2D: {
                gl.glBindTexture(3553, this.id);
                gl.glEnable(3553);
                break;
            }
            case TYPE_CUBEMAP: {
                gl.glBindTexture(34067, this.id);
                gl.glEnable(34067);
            }
        }
        if (textureUnit != 0) {
            gl.glActiveTexture(33984);
        }
    }

    public void bind(GL gl, Shader shader, String uniformName) {
        this.bind(gl, shader, uniformName, 0);
    }

    public void bind(GL gl, Shader shader, String uniformName, int textureUnit) {
        this.bind(gl, textureUnit);
        shader.applyUniform(gl, uniformName, textureUnit);
    }

    public void unbind(GL gl) {
        this.unbind(gl, 0);
    }

    public void unbind(GL gl, int textureUnit) {
        gl.glActiveTexture(33984 + textureUnit);
        switch (this.type) {
            case TYPE_2D: {
                gl.glDisable(3553);
                break;
            }
            case TYPE_CUBEMAP: {
                gl.glDisable(34067);
            }
        }
        gl.glActiveTexture(33984);
    }

    public static enum Type {
        TYPE_2D,
        TYPE_CUBEMAP;

    }
}

