/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.gl.texturing;

import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.game.util.Vector2;

public abstract class RenderedTexture
extends Texture {
    protected final int size;

    protected RenderedTexture(Texture.Type type, int size) {
        super(type);
        this.size = size;
    }

    @Override
    public void loadGl(GL gl) {
        super.loadGl(gl);
        switch (this.type) {
            case TYPE_2D: {
                gl.glBindTexture(3553, this.id);
                gl.glTexImage2D(3553, 0, 32849, this.size, this.size, 0, 6407, 5121, null);
                gl.glTexParameteri(3553, 10241, 9729);
                gl.glTexParameteri(3553, 10240, 9729);
                gl.glTexParameteri(3553, 10242, 33071);
                gl.glTexParameteri(3553, 10243, 33071);
                gl.glBindTexture(3553, 0);
                break;
            }
            case TYPE_CUBEMAP: {
                gl.glBindTexture(34067, this.id);
                gl.glTexImage2D(34069, 0, 32856, this.size, this.size, 0, 6408, 5121, null);
                gl.glTexImage2D(34070, 0, 32856, this.size, this.size, 0, 6408, 5121, null);
                gl.glTexImage2D(34071, 0, 32856, this.size, this.size, 0, 6408, 5121, null);
                gl.glTexImage2D(34072, 0, 32856, this.size, this.size, 0, 6408, 5121, null);
                gl.glTexImage2D(34073, 0, 32856, this.size, this.size, 0, 6408, 5121, null);
                gl.glTexImage2D(34074, 0, 32856, this.size, this.size, 0, 6408, 5121, null);
                gl.glTexParameteri(34067, 10241, 9729);
                gl.glTexParameteri(34067, 10240, 9729);
                gl.glBindTexture(34067, 0);
            }
        }
    }

    public abstract void startRendering(GL var1, Axis var2);

    public abstract void stopRendering(GL var1);

    public Vector2 getSize() {
        return new Vector2(this.size, this.size);
    }

    public static enum Axis {
        POSITIVE_X,
        NEGATIVE_X,
        POSITIVE_Y,
        NEGATIVE_Y,
        POSITIVE_Z,
        NEGATIVE_Z;

    }
}

