/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.gl.texturing;

import com.sun.opengl.util.BufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import lonelycoders.ufohippa.client.gl.texturing.ImageTexture;

public class FlareTexture
extends ImageTexture {
    public FlareTexture(final int size) {
        super(new ImageTexture.ImageGenerator(){

            @Override
            public int getWidth() {
                return size;
            }

            @Override
            public int getHeight() {
                return size;
            }

            @Override
            public ImageTexture.Format getFormat() {
                return ImageTexture.Format.GRAYSCALE;
            }

            @Override
            public Buffer getPixels() {
                ByteBuffer pixels = BufferUtil.newByteBuffer(size * size);
                double radius = (double)(size - 1) / 2.0;
                double edge = Math.exp(-1.0);
                for (int y = 0; y < size; ++y) {
                    for (int x = 0; x < size; ++x) {
                        double x2 = ((double)x - radius) / radius;
                        double y2 = ((double)y - radius) / radius;
                        double alpha = Math.exp(-(x2 * x2 + y2 * y2));
                        alpha = Math.max(0.0, (alpha - edge) / (1.0 - edge));
                        pixels.put((byte)(alpha * 256.0));
                    }
                }
                pixels.flip();
                return pixels;
            }
        });
    }
}

