/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.gl.texturing;

import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;
import lonelycoders.ufohippa.client.gl.texturing.RenderedTexture;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.general.Logger;

public class FBOTexture
extends RenderedTexture {
    private int FBOId;
    private final Texture.Type type;
    private static final Map<RenderedTexture.Axis, Integer> axisToCubeSide = new HashMap<RenderedTexture.Axis, Integer>();

    public FBOTexture(Texture.Type type, int size) {
        super(type, size);
        this.type = type;
    }

    @Override
    public void load() {
    }

    @Override
    public void loadGl(GL gl) {
        super.loadGl(gl);
        int[] temp = new int[2];
        gl.glGenFramebuffersEXT(2, temp, 0);
        this.FBOId = temp[0];
        int FBODepthBufferId = temp[1];
        gl.glBindFramebufferEXT(36160, this.FBOId);
        switch (this.type) {
            case TYPE_2D: {
                gl.glFramebufferTexture2DEXT(36160, 36064, 3553, this.id, 0);
                break;
            }
            case TYPE_CUBEMAP: {
                gl.glFramebufferTexture2DEXT(36160, 36064, 34069, this.id, 0);
                gl.glFramebufferTexture2DEXT(36160, 36064, 34070, this.id, 0);
                gl.glFramebufferTexture2DEXT(36160, 36064, 34071, this.id, 0);
                gl.glFramebufferTexture2DEXT(36160, 36064, 34072, this.id, 0);
                gl.glFramebufferTexture2DEXT(36160, 36064, 34073, this.id, 0);
                gl.glFramebufferTexture2DEXT(36160, 36064, 34074, this.id, 0);
            }
        }
        int status = gl.glCheckFramebufferStatusEXT(36160);
        switch (status) {
            case 36053: {
                Logger.detail("FBO texture succesfully created");
                break;
            }
            case 36054: {
                throw new RuntimeException("FrameBuffer: " + this.FBOId + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT exception");
            }
            case 36055: {
                throw new RuntimeException("FrameBuffer: " + this.FBOId + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT exception");
            }
            case 36057: {
                throw new RuntimeException("FrameBuffer: " + this.FBOId + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT exception");
            }
            case 36059: {
                throw new RuntimeException("FrameBuffer: " + this.FBOId + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT exception");
            }
            case 36058: {
                throw new RuntimeException("FrameBuffer: " + this.FBOId + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT exception");
            }
            case 36060: {
                throw new RuntimeException("FrameBuffer: " + this.FBOId + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT exception");
            }
            default: {
                throw new RuntimeException("Unexpected reply from glCheckFramebufferStatusEXT: " + status);
            }
        }
        gl.glBindRenderbufferEXT(36161, FBODepthBufferId);
        gl.glRenderbufferStorageEXT(36161, 6402, this.size, this.size);
        gl.glFramebufferRenderbufferEXT(36160, 36096, 36161, FBODepthBufferId);
        gl.glBindFramebufferEXT(36160, 0);
    }

    @Override
    public void startRendering(GL gl, RenderedTexture.Axis axis) {
        gl.glPushAttrib(2048);
        gl.glViewport(0, 0, this.size, this.size);
        gl.glBindFramebufferEXT(36160, this.FBOId);
        switch (this.type) {
            case TYPE_2D: {
                gl.glFramebufferTexture2DEXT(36160, 36064, 3553, this.id, 0);
                break;
            }
            case TYPE_CUBEMAP: {
                gl.glFramebufferTexture2DEXT(36160, 36064, axisToCubeSide.get((Object)axis), this.id, 0);
            }
        }
    }

    @Override
    public void stopRendering(GL gl) {
        gl.glBindFramebufferEXT(36160, 0);
        gl.glPopAttrib();
    }

    static {
        axisToCubeSide.put(RenderedTexture.Axis.POSITIVE_X, 34069);
        axisToCubeSide.put(RenderedTexture.Axis.NEGATIVE_X, 34070);
        axisToCubeSide.put(RenderedTexture.Axis.POSITIVE_Y, 34071);
        axisToCubeSide.put(RenderedTexture.Axis.NEGATIVE_Y, 34072);
        axisToCubeSide.put(RenderedTexture.Axis.POSITIVE_Z, 34073);
        axisToCubeSide.put(RenderedTexture.Axis.NEGATIVE_Z, 34074);
    }
}

