/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.client.gl;

import com.sun.opengl.util.BufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import lonelycoders.ufohippa.client.gl.MeshGL;
import lonelycoders.ufohippa.client.gl.MeshUtil;
import lonelycoders.ufohippa.client.gl.Shader;
import lonelycoders.ufohippa.client.gl.texturing.ImageTexture;
import lonelycoders.ufohippa.client.gl.texturing.Texture;
import lonelycoders.ufohippa.client.resource.ResourceKey;
import lonelycoders.ufohippa.client.resource.ResourceManager;

public class GameResources {
    public static final ResourceKey<Shader> SHADER_PHONG_MULTILIGHT = new ResourceKey("Phong shader multilight");
    public static final ResourceKey<MeshGL> TILE_CUBE = new ResourceKey("Tile cube");
    public static final ResourceKey<MeshGL> TILE_ROUNDED_CUBE = new ResourceKey("Tile rounded cube");
    public static final ResourceKey<MeshGL> TILE_QUAD = new ResourceKey("Tile quad");
    public static final ResourceKey<Texture> WHITE_TEXTURE = new ResourceKey("White texture");

    public static void load(ResourceManager resourceManager) {
        resourceManager.addResource(SHADER_PHONG_MULTILIGHT, new Shader("shaders/phong_multilight"));
        resourceManager.addResource(TILE_CUBE, new MeshGL(MeshUtil.createCube(), MeshGL.RenderType.VERTEX_BUFFER));
        resourceManager.addResource(TILE_ROUNDED_CUBE, new MeshGL(MeshUtil.createRoundedCube(0.1f), MeshGL.RenderType.VERTEX_BUFFER));
        resourceManager.addResource(TILE_QUAD, new MeshGL(MeshUtil.createQuad(), MeshGL.RenderType.VERTEX_BUFFER));
        resourceManager.addResource(WHITE_TEXTURE, new ImageTexture(new ImageTexture.ImageGenerator(){

            @Override
            public int getWidth() {
                return 1;
            }

            @Override
            public int getHeight() {
                return 1;
            }

            @Override
            public ImageTexture.Format getFormat() {
                return ImageTexture.Format.GRAYSCALE;
            }

            @Override
            public Buffer getPixels() {
                ByteBuffer pixels = BufferUtil.newByteBuffer(1);
                pixels.put((byte)-1);
                pixels.flip();
                return pixels;
            }
        }));
    }
}

