#!/bin/sh

DSTPATH="$1"
if test -d "$DSTPATH" ; then
	echo "Copying relevant files to $DSTPATH"
else
	echo "Not a directory: \"$DSTPATH\""
	exit 1
fi

diff_copy()
{
	if test -f "$1" ; then
		if test -f "$2" ; then
			diff -q $1 $2
			if test "$?" -ne "0" ; then
				echo "Replacing $2 with $1"
				cp $1 $2
			fi
		else
			echo "Installing $1 to $2"
			cp $1 $2
		fi
	fi
}

dstcp()
{
	diff_copy "$1" "$DSTPATH/$1"
}

dstcp "fnt/default.xml"
dstcp "fnt/default_0.png"
dstcp "fnt/default_1.png"
dstcp "fnt/default_2.png"
dstcp "shader/2d.xml"
dstcp "shader/2d_font.xml"
dstcp "shader/2d_texture.xml"

dstcp "src/data/data_generic.cpp"
dstcp "src/data/generic.hpp"
dstcp "src/defaults.hpp"
dstcp "src/gfx/attribute.hpp"
dstcp "src/gfx/array.cpp"
dstcp "src/gfx/array.hpp"
dstcp "src/gfx/color.cpp"
dstcp "src/gfx/color.hpp"
dstcp "src/gfx/font.cpp"
dstcp "src/gfx/font.hpp"
dstcp "src/gfx/generic.hpp"
dstcp "src/gfx/gfx_generic.hpp"
dstcp "src/gfx/glyph.cpp"
dstcp "src/gfx/glyph.hpp"
dstcp "src/gfx/image.cpp"
dstcp "src/gfx/image.hpp"
dstcp "src/gfx/light_directional.hpp"
dstcp "src/gfx/shader.cpp"
dstcp "src/gfx/shader.hpp"
dstcp "src/gfx/surface.cpp"
dstcp "src/gfx/surface.hpp"
dstcp "src/gfx/surface_base.cpp"
dstcp "src/gfx/surface_base.hpp"
dstcp "src/gfx/surface_screen.cpp"
dstcp "src/gfx/surface_screen.hpp"
dstcp "src/gfx/texture.hpp"
dstcp "src/gfx/texture_2d.cpp"
dstcp "src/gfx/texture_2d.hpp"
dstcp "src/gfx/uniform.hpp"
dstcp "src/math/generic.hpp"
dstcp "src/math/mat.hpp"
dstcp "src/math/rect.hpp"
dstcp "src/math/vec.hpp"
dstcp "src/thr/dispatch.hpp"
dstcp "src/thr/dispatch.cpp"
dstcp "src/ui/event.hpp"
dstcp "src/ui/event_key.hpp"
dstcp "src/ui/event_misc.hpp"
dstcp "src/ui/event_mouse_button.hpp"
dstcp "src/ui/event_mouse_motion.hpp"
dstcp "src/ui/fps_counter.cpp"
dstcp "src/ui/fps_counter.hpp"
dstcp "src/ui/generic.hpp"
dstcp "src/ui/ui_generic.cpp"
dstcp "src/ui/ui_stack.cpp"
dstcp "src/ui/ui_stack.hpp"
dstcp "src/ui/ui_state.cpp"
dstcp "src/ui/ui_state.hpp"

dstcp "src/fontcompiler/AUTHORS"
dstcp "src/fontcompiler/COPYING"
dstcp "src/fontcompiler/ChangeLog"
dstcp "src/fontcompiler/INSTALL"
dstcp "src/fontcompiler/Makefile.am"
dstcp "src/fontcompiler/NEWS"
dstcp "src/fontcompiler/README"
dstcp "src/fontcompiler/SConstruct"
dstcp "src/fontcompiler/acinclude.m4"
dstcp "src/fontcompiler/autogen.sh"
dstcp "src/fontcompiler/configure.ac"
dstcp "src/fontcompiler/fontcompiler.cpp"
dstcp "src/fontcompiler/ft_face.cpp"
dstcp "src/fontcompiler/ft_face.hpp"
dstcp "src/fontcompiler/ft_glyph.cpp"
dstcp "src/fontcompiler/ft_glyph.hpp"

dstcp "src/td_main.cpp"

exit 0
