#include "ui/text_area.hpp"

#include "gfx/surface.hpp"
#include "ui/text_row.hpp"
#include "ui/text_word.hpp"

using namespace ui;

TextArea::TextArea(const math::rect2f &prestrict, float fs,
		const gfx::Font &fnt, TextGravity grav) :
	TextRect(prestrict.size()),
	_boundary(prestrict),
	_margin_left(0.0f),
	_margin_right(0.0f),
	_margin_top(0.0f),
	_margin_bottom(0.0f),
	_font_size(fs),
	_font(fnt),
	_gravity(grav) { }

math::rect2f TextArea::getContentArea() const
{
	//std::cout << "Content size: " << _dimensions << std::endl;
	switch(_gravity)
	{
		case GRAVITY_UP_LEFT:
			return math::rect2f(_boundary.x1() + _margin_left,
					_boundary.y1() + _boundary.h() - _dimensions.y() - _margin_top,
					_dimensions);

		case GRAVITY_UP_RIGHT:
			return math::rect2f(_boundary.x1() + _boundary.w() - _dimensions.x() - _margin_right,
					_boundary.y1() + _boundary.h() - _dimensions.y() - _margin_top,
					_dimensions);

		case GRAVITY_DOWN_LEFT:
			return math::rect2f(_boundary.x1() + _margin_left,
					_boundary.y1() + _margin_bottom,
					_dimensions);

		case GRAVITY_DOWN_RIGHT:
			return math::rect2f(_boundary.x1() + _boundary.w() - _dimensions.x() - _margin_right,
					_boundary.y1() + _margin_bottom,
					_dimensions);

		case GRAVITY_UP:
			return math::rect2f(_boundary.x1() + _margin_left + (_boundary.w() - _dimensions.x()) * 0.5f,
					_boundary.y1() + _boundary.h() - _dimensions.y() - _margin_top,
					_dimensions);

		case GRAVITY_DOWN:
			return math::rect2f(_boundary.x1() + _margin_left + (_boundary.w() - _dimensions.x()) * 0.5f,
					_boundary.y1() + _margin_bottom,
					_dimensions);

		case GRAVITY_LEFT:
			return math::rect2f(_boundary.x1() + _margin_left,
					_boundary.y1() + _margin_bottom + (_boundary.h() - _dimensions.y()) * 0.5f,
					_dimensions);

		case GRAVITY_RIGHT:
			return math::rect2f(_boundary.x1() + _boundary.w() - _dimensions.x() - _margin_right,
					_boundary.y1() + _margin_bottom + (_boundary.h() - _dimensions.y()) * 0.5f,
					_dimensions);

		case GRAVITY_CENTER:
		default:
			return math::rect2f(_boundary.x1() + _margin_left + (_boundary.w() - _dimensions.x()) * 0.5f,
					_boundary.y1() + _margin_bottom + (_boundary.h() - _dimensions.y()) * 0.5f,
					_dimensions);
	}
}

void TextArea::render(const gfx::Color &tcol, const gfx::Color &bcol) const
{
	//std::cout << "Contents: " << bord << std::endl;
	math::vec2f margin_lb(_margin_left, _margin_bottom),
		margin_rt(_margin_right, _margin_top);
	math::rect2f carea = this->getContentArea();
	math::rect2f bord = math::rect2f(
			math::vec2f(carea.pos() - margin_lb),
			math::vec2f(carea.size() + margin_lb + margin_rt));

	//std::cout << "Borders: " << bord << std::endl;

	gfx::bind_shader_2d();
	for(unsigned ii = 0; (ii < 8); ++ii)
	{
		gfx::draw_fill(ii, bcol);
	}

	float rs1 = _font_size * 0.25f;
	gfx::draw_fill(0, bord.x1(), bord.y1() + rs1);
	gfx::draw_fill(1, bord.x1(), bord.y2() - rs1);
	gfx::draw_fill(2, bord.x1() + rs1, bord.y2());
	gfx::draw_fill(3, bord.x2() - rs1, bord.y2());
	gfx::draw_fill(4, bord.x2(), bord.y2() - rs1);
	gfx::draw_fill(5, bord.x2(), bord.y1() + rs1);
	gfx::draw_fill(6, bord.x2() - rs1, bord.y1());
	gfx::draw_fill(7, bord.x1() + rs1, bord.y1());
	gfx::draw_arrays(GL_LINE_LOOP, 8);

	float rs2 = _font_size * 0.1f;
	gfx::draw_fill(0, bord.x1() + rs2, bord.y1() + rs1);
	gfx::draw_fill(1, bord.x1() + rs2, bord.y2() - rs1);
	gfx::draw_fill(2, bord.x1() + rs1, bord.y2() - rs2);
	gfx::draw_fill(3, bord.x2() - rs1, bord.y2() - rs2);
	gfx::draw_fill(4, bord.x2() - rs2, bord.y2() - rs1);
	gfx::draw_fill(5, bord.x2() - rs2, bord.y1() + rs1);
	gfx::draw_fill(6, bord.x2() - rs1, bord.y1() + rs2);
	gfx::draw_fill(7, bord.x1() + rs1, bord.y1() + rs2);
	gfx::draw_arrays(GL_LINE_LOOP, 8);

	gfx::bind_shader_2d_font();
	gfx::draw_fill(0, tcol);
	gfx::draw_fill(1, tcol);
	gfx::draw_fill(2, tcol);
	gfx::draw_fill(3, tcol);
	this->renderText(carea);
}

void TextArea::renderText() const
{
	this->renderText(this->getContentArea());
}

void TextArea::renderText(const math::rect2f &carea) const
{
	gfx::TextJustify justify;
	switch(_gravity)
	{
		case GRAVITY_UP_LEFT:
		case GRAVITY_DOWN_LEFT:
		case GRAVITY_LEFT:
			justify = gfx::LEFT;
			break;

		case GRAVITY_UP_RIGHT:
		case GRAVITY_DOWN_RIGHT:
		case GRAVITY_RIGHT:
			justify = gfx::RIGHT;
			break;

		case GRAVITY_UP:
		case GRAVITY_DOWN:
		case GRAVITY_CENTER:
		default:
			justify = gfx::CENTER;
			break;
	}

	this->TextRect::renderText(carea, _font, _font_size, justify);
}

void TextArea::updateBoundary()
{
	this->setLimits(_boundary.w() - _margin_left - _margin_right,
			_boundary.h() - _margin_bottom - _margin_top);
}

