#ifndef UI_EVENT_MOUSE_BUTTON_HPP
#define UI_EVENT_MOUSE_BUTTON_HPP

#include "ui/event.hpp"

namespace ui
{
	/** \brief Mouse button event.
	 */
	struct EventMouseButton : Event
	{
		/** \brief Constructor.
		 *
		 * @param pcode Keycode.
		 * @param ppress Press flag.
		 */
		inline EventMouseButton(int pcode, bool ppress, int px, int py)
			: Event(MOUSE_BUTTON)
		{
			_code = pcode;
			_press = ppress;
			_coord = math::vec2i(px, py);
		}
	};
}

#endif
