#include "thr/generic.hpp"

#ifdef WIN32
#include "SDL.h"
#else
#include <sys/time.h>
#endif

using namespace thr;

boost::thread::id thr::privileged_thread_id;

bool thr::is_primary_thread()
{
	return (boost::this_thread::get_id() == privileged_thread_id);
}

void thr::thr_init()
{
	boost::thread::id nat;
	if(nat != privileged_thread_id)
	{
		std::stringstream sstr;
		sstr << "thread system already initialized";
		BOOST_THROW_EXCEPTION(std::runtime_error(sstr.str()));
	}
	privileged_thread_id = boost::this_thread::get_id();
}

uint64_t thr::usec_get_timestamp()
{
#if defined(WIN32)
	return static_cast<uint64_t>(SDL_GetTicks() * 1000);
	//return GetTickCount64()*1000;
#else
	struct timeval tv;
	gettimeofday(&tv, NULL);
	return static_cast<uint64_t>(tv.tv_sec) * 1000000 +
		static_cast<uint64_t>(tv.tv_usec);
#endif
}

void thr::usec_sleep(uint64_t op)
{
#if defined(WIN32)
	SDL_Delay(static_cast<unsigned>(op / 1000));
#else
	struct timespec ts;
	ts.tv_sec = static_cast<time_t>(op / 1000000000);
	ts.tv_nsec = static_cast<long int>(op % 1000000000);
	nanosleep(&ts, NULL);
#endif
}

