#ifndef OB_VISUALIZATION_MESH
#define OB_VISUALIZATION_MESH

#include "data/store.hpp"
#include "gfx/mesh.hpp"

namespace ob
{
	class VisualizationMesh :
		public gfx::Mesh
	{
		private:
			/** Array for meshes of this type. */
			gfx::BufferInterleavedTCV m_buf;

		public:
			/** \brief Constructor. */
			VisualizationMesh() { }

			/** \brief Constructor.
			 *
			 * @param pfname Filename to load from.
			 */
			VisualizationMesh(const std::string &pfname);

			/** \brief Destructor. */
			virtual ~VisualizationMesh() { }

		public:
			/** \cond */
			virtual void compile();
			virtual void draw(const gfx::Shader &pshader, const math::mat4f &pmat) const;
			/** \endcond */
	};
}

#endif
