#include "ob_particle.hpp"

#include "math/random.hpp"
#include "gfx/surface.hpp"
#include "ob_game.hpp"
#include "ob_globals.hpp"

using namespace ob;

/** Rotating thingy for morph selection. */
static unsigned morph_rotation = 0;

/** Morph rotation array. */
int8_t morphs[] =
{
	127, 0, 127, 0,
	0, 127, 0, -128,
	-128, 0, -128, 0,
	0, -128, 0, 127,
	-128, 0, 127, 0,
	0, 127, 0, 127,
	0, 127, 0, -128,
	0, -128, 0, -128
};

/** Texcoord rotation array. */
float texcoords[] =
{
	0.0f, 0.0f,
	0.0f, 1.0f,
	1.0f, 1.0f,
	1.0f, 0.0f,
	1.0f, 0.0f,
	0.0f, 0.0f,
	0.0f, 1.0f,
	1.0f, 1.0f
};

Particle::Particle(const gfx::Color &col, const math::vec3f &pos, float size,
		const math::vec3f &dir, int lifetime, float dsize) :
	m_pos(pos),
	m_size(size),
	m_dir(dir),
	m_lifetime(1.0f),
	m_lifetime_dec(1.0f / static_cast<float>(lifetime)),
	m_size_delta(dsize)
{
	morph_rotation = (morph_rotation + 1) & 0x7;

	m_morph = *reinterpret_cast<uint32_t*>(morphs + (morph_rotation * 4));

	unsigned mr2 = morph_rotation * 2;
	m_texcoord.x() = texcoords[mr2 + 0];
	m_texcoord.y() = texcoords[mr2 + 1];

	this->setColor(col);
}

void Particle::feed()
{
	void *color_ptr = reinterpret_cast<void*>(m_color_array);
	float csize = m_size + (1.0f - m_lifetime) * m_size_delta;

	m_color_array[3] = static_cast<uint8_t>(
			math::lround((m_col.a() * m_lifetime) * 255.0f));

	gfx::billboard_fill(m_morph, m_texcoord,
			*reinterpret_cast<uint32_t*>(color_ptr), m_pos, csize);
}

void Particle::setColor(const gfx::Color &op)
{
	m_col = op;
	m_color_array[0] = static_cast<uint8_t>(op.ri());
	m_color_array[1] = static_cast<uint8_t>(op.gi());
	m_color_array[2] = static_cast<uint8_t>(op.bi());
}

bool Particle::update()
{
	m_pos += m_dir * game->getTimestep();

	m_lifetime -= m_lifetime_dec;
	return (0.0f < m_lifetime);
}

ParticleTypeEnum Particle::randomCrackleParticle()
{
	static const ParticleTypeEnum aa = CRACKLE_1;
	static const ParticleTypeEnum bb = CRACKLE_4;
	return static_cast<ParticleTypeEnum>(
			math::mrand(static_cast<int>(aa), static_cast<int>(bb)));
}

ParticleTypeEnum Particle::randomSmokeHardParticle()
{
	static const ParticleTypeEnum aa = SMOKE_HARD_1;
	static const ParticleTypeEnum bb = SMOKE_HARD_4;
	return static_cast<ParticleTypeEnum>(
			math::mrand(static_cast<int>(aa), static_cast<int>(bb)));
}

ParticleTypeEnum Particle::randomSmokeSoftParticle()
{
	static const ParticleTypeEnum aa = SMOKE_SOFT_1;
	static const ParticleTypeEnum bb = SMOKE_SOFT_4;
	return static_cast<ParticleTypeEnum>(
			math::mrand(static_cast<int>(aa), static_cast<int>(bb)));
}

ParticleTypeEnum Particle::randomShockwaveNarrowParticle()
{
	static const ParticleTypeEnum aa = SHOCKWAVE_NARROW_1;
	static const ParticleTypeEnum bb = SHOCKWAVE_NARROW_4;
	return static_cast<ParticleTypeEnum>(
			math::mrand(static_cast<int>(aa), static_cast<int>(bb)));
}

ParticleTypeEnum Particle::randomShockwaveWideParticle()
{
	static const ParticleTypeEnum aa = SHOCKWAVE_WIDE_1;
	static const ParticleTypeEnum bb = SHOCKWAVE_WIDE_4;
	return static_cast<ParticleTypeEnum>(
			math::mrand(static_cast<int>(aa), static_cast<int>(bb)));
}

ParticleTypeEnum Particle::randomSparkleParticle()
{
	static const ParticleTypeEnum aa = SPARKLE_1;
	static const ParticleTypeEnum bb = SPARKLE_6;
	return static_cast<ParticleTypeEnum>(
			math::mrand(static_cast<int>(aa), static_cast<int>(bb)));
}
