#include "ob_console_state.hpp"

#include "ui/ui_stack.hpp"
#include "ob_game.hpp"
#include "ob_globals.hpp"
#include "ob_menu_state.hpp"

using namespace ob;

ConsoleState::ConsoleState(ui::Console &op) :
	ui::ConsoleState(op, false) { }

void ConsoleState::update(gfx::SurfaceScreen &screen, ui::UiStack &st,
		bool prender)
{
	if(glob->isDone())
	{
		st.pushStateAfter(new MenuState(glob->getMenuMain()));
		_alive = false;
	}
	else
	{
		this->ui::ConsoleState::update(screen, st, prender);
	}
}

