#include "ob_billboard.hpp"

#include "gfx/surface.hpp"
#include "math/random.hpp"

using namespace ob;

Billboard::Billboard(const gfx::Texture2D *tex) :
	m_billboard(tex),
	m_billboard_disabled(false) { }

void Billboard::enableRandom(int level)
{
	m_billboard_disabled = (math::mrand(0, level) == 0);
}

const gfx::Texture2D* Billboard::updateBillboard(const gfx::Texture2D *tex) const
{
	// If same, just return.
	if(tex == m_billboard)
	{
		return tex;
	}

	// Flush if tex is something.
	if(tex)
	{
		gfx::billboard_flush();
	}

	// Start anew with billboards of this.
	gfx::billboard_reset(*m_billboard);
	return m_billboard;
}

