#include <boost/test/unit_test.hpp>

#include "gfx/color.hpp"

using namespace gfx;

namespace
{
	const float tolerance = 0.0001f;
}

#define FLOAT_CHECK_EQUAL(x, y) \
	BOOST_CHECK_CLOSE( (x), (y), tolerance )

BOOST_AUTO_TEST_SUITE( color )

BOOST_AUTO_TEST_CASE( accessors )
{
	Color ci(248, 0, 32, 255);
	FLOAT_CHECK_EQUAL(ci.r(), 0.972549f);
	FLOAT_CHECK_EQUAL(ci.g(), 0.0f);
	FLOAT_CHECK_EQUAL(ci.b(), 0.1254902f);
	FLOAT_CHECK_EQUAL(ci.a(), 1.0f);

	Color cf(0.75f, 1.0f, 0.0f, 0.24f);
	BOOST_CHECK_EQUAL(cf.ri(), 191);
	BOOST_CHECK_EQUAL(cf.gi(), 255);
	BOOST_CHECK_EQUAL(cf.bi(), 0);
	BOOST_CHECK_EQUAL(cf.ai(), 61);
}

BOOST_AUTO_TEST_SUITE_END()
