#ifndef GFX_SURFACE_SCREEN_HPP
#define GFX_SURFACE_SCREEN_HPP

#include "gfx/surface.hpp"

namespace gfx
{
	/** \brief Class representing window, that can be drawn into.
	 */
	class SurfaceScreen : public Surface
	{
		private:
			/** SDL surface contained. */
			SDL_Surface *_screen;

		public:
			/** \brief Default constructor.
			 *
			 * @param pw Width of this surface.
			 * @param ph Width of this surface.
			 * @param pb Bit depth of this surface.
			 * @param fs Fullscreen toggle.
			 */
			SurfaceScreen(int pw, int ph, int pb, bool fs = false);

			/** Destructor.
			 */
			~SurfaceScreen();
		
		public:
			/** \cond */
			virtual void clear(bool = true, bool = true);
			virtual void setBoundary(int, int, int, int);
			virtual void update();
			/** \endcond */

		private:
			/** \brief Create SDL video mode flags for this surface.
			 *
			 * @param fs Fullscreen toggle.
			 * @return Flag integer.
			 */
			static inline int createSdlFlags(bool fs)
			{
				return SDL_OPENGL | (fs ? SDL_FULLSCREEN : 0);
			}

			/** \brief Set OpenGL attributes.
			 *
			 * Called prior to calling surface creation.
			 *
			 * @param bit_depth Bit depth to use.
			 */
			static inline void setGlAttributes()
			{
				SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
			}

		public:
			/** \brief Output this to a stream.
			 *
			 * @param ss Target stream.
			 * @return Stream after input.
			 */
			virtual std::ostream& put(std::ostream &ss) const;

      static boost::tuple<unsigned, unsigned, unsigned>
        parseResolution(const std::string & r);
	};
}

#endif
