#include "gfx/mesh_static.hpp"

#include "gfx/shader.hpp"
#include "thr/dispatch.hpp"

using namespace gfx;

MeshStatic::MeshStatic(const std::string &pfname)
{
	this->load(pfname);
}

void MeshStatic::compile()
{
	// Texcoords is sometimes smaller than the others.
	if(m_texcoord.size() < m_vertex.size())
	{
		m_texcoord.resize(m_vertex.size(), math::vec2f(0.0f, 0.0f));
	}

	this->calcNormals();
	thr::dispatch_privileged(boost::bind(&BufferInterleavedTCNV::update, &m_buf,
				boost::ref(m_texcoord), boost::ref(m_color), boost::ref(m_normal),
				boost::ref(m_vertex)));
	thr::wait_privileged(boost::bind(&Mesh::taskElem, this));
	m_lod.compile(m_vertex);
}

void MeshStatic::draw(const Shader &psh, const math::mat4f &pmat) const
{
	if(!m_textures.empty())
	{
		m_textures[0]->bind(psh.getUniformTex(), 0);
	}
	m_buf.feed(psh.getAttrTexcoord(), psh.getAttrColor(), psh.getAttrNormal(),
  		psh.getAttrVertex());
	m_elem.bind();
	m_lod.draw(pmat);
}

void MeshStatic::unreserve()
{
	m_buf.unreserve();
	this->Mesh::unreserve();
}

