#include "gfx/mesh_ball.hpp"

#include "gfx/shader.hpp"

using namespace gfx;

MeshBall::MeshBall(unsigned subdivision, unsigned subdivision_coalesce)
{
	this->compile(subdivision, subdivision_coalesce);
}

void MeshBall::compile()
{
	this->compile(0);
}

void MeshBall::compile(unsigned subdivision, unsigned subdivision_coalesce)
{
	this->subdivide(subdivision);

	this->coalesce(subdivision_coalesce, subdivision);

	this->calcNormals();

	m_buf.update(m_texcoord, m_color, m_normal, m_vertex);
	m_elem.update(m_lod);
	m_lod.compile(m_vertex);
}

void MeshBall::draw(const Shader &psh, const math::mat4f &pmat) const
{
	m_buf.feed(psh.getAttrTexcoord(), psh.getAttrColor(), psh.getAttrNormal(),
  		psh.getAttrVertex());
	m_elem.bind();
	m_lod.draw(pmat);
}

void MeshBall::unreserve()
{
	m_buf.unreserve();
	this->Mesh::unreserve();
}

