#ifndef GFX_MESH_ANIMATED_HPP
#define GFX_MESH_ANIMATED_HPP

#include "gfx/buffer.hpp"
#include "gfx/mesh.hpp"

namespace gfx
{
	class MeshAnimated : public Mesh
	{
		private:
			/** Buffer for drawing. */
			BufferInterleavedBBTCNV m_buf;

		public:
			/** \brief Empty constructor. */
			MeshAnimated() { }

			/** \brief Load constructor.
			 *
			 * @param pfname File to load from.
			 */
			MeshAnimated(const std::string &pfname);

			/** \brief Destructor. */
			virtual ~MeshAnimated() { }

		public:
			/** \cond */
			virtual void compile();
			virtual void draw(const Shader &pshader, const math::mat4f &pmat) const;
			/** \endcond */

		protected:
			/** \cond */
			virtual void unreserve();
			/** \endcond */
	};
}

#endif
