#include "gfx/image.hpp"

using namespace gfx;
namespace gil = boost::gil;

ImageGray8::ImageGray8(unsigned pw, unsigned ph) :
	Image<gil::gray8_image_t>(pw, ph),
	_view(gil::view(_img)) { }

ImageGray8::ImageGray8(const std::string &pfname)
{
	this->load(pfname);
}

void ImageGray8::load(const std::string &pfname)
{
	this->loadBase(pfname);
	_view = gil::view(_img);
}

void ImageGray8::write(const std::string &pfname)
{
	if(is_png(pfname))
	{
		boost::gil::png_write_view(pfname, _view);
	}
	else if(is_jpeg(pfname))
	{
		boost::gil::jpeg_write_view(pfname, _view);
	}
	else
	{
		std::ostringstream str;
		str << "unknown image type: " << pfname;
		BOOST_THROW_EXCEPTION(std::runtime_error(str.str()));
	}
}

float ImageGray8::getHeightValue(float px, float py) const
{
	int rx = math::lround(px * static_cast<float>(_img.width() - 1)),
			ry = math::lround(py * static_cast<float>(_img.height() - 1));
	rx = std::max(std::min(rx, static_cast<int>(_img.width())), 0);
	ry = std::max(std::min(ry, static_cast<int>(_img.height())), 0);
	return this->getLuminance(rx, ry);
}

ImageGray16::ImageGray16(unsigned pw, unsigned ph) :
	Image<gil::gray16_image_t>(pw, ph),
	_view(gil::view(_img)) { }

ImageGray16::ImageGray16(const std::string &pfname)
{
	this->load(pfname);
}

void ImageGray16::load(const std::string &pfname)
{
	this->loadBaseDisregardJpeg(pfname);
	_view = gil::view(_img);
}

void ImageGray16::write(const std::string &pfname)
{
	if(is_png(pfname))
	{
		boost::gil::png_write_view(pfname, _view);
	}
	else
	{
		std::ostringstream str;
		str << "unknown image type: " << pfname;
		BOOST_THROW_EXCEPTION(std::runtime_error(str.str()));
	}
}

ImageRGB::ImageRGB(unsigned pw, unsigned ph) :
	Image<gil::rgb8_image_t>(pw, ph),
	_view(gil::view(_img)) { }

ImageRGB::ImageRGB(const std::string &pfname)
{
	this->load(pfname);
}

void ImageRGB::load(const std::string &pfname)
{
	this->loadBase(pfname);
	_view = gil::view(_img);
}

void ImageRGB::write(const std::string &pfname)
{
	if(is_png(pfname))
	{
		boost::gil::png_write_view(pfname, _view);
	}
	else if(is_jpeg(pfname))
	{
		boost::gil::jpeg_write_view(pfname, _view);
	}
	else
	{
		std::ostringstream str;
		str << "unknown image type: " << pfname;
		BOOST_THROW_EXCEPTION(std::runtime_error(str.str()));
	}
}

ImageRGBA::ImageRGBA(unsigned pw, unsigned ph) :
	Image<gil::rgba8_image_t>(pw, ph),
	_view(gil::view(_img)) { }

ImageRGBA::ImageRGBA(const std::string &pfname)
{
	this->load(pfname);
}

void ImageRGBA::load(const std::string &pfname)
{
	this->loadBaseDisregardJpeg(pfname);
	_view = gil::view(_img);
}

void ImageRGBA::write(const std::string &pfname)
{
	if(is_png(pfname))
	{
		boost::gil::png_write_view(pfname, _view);
	}
	else
	{
		std::ostringstream str;
		str << "unknown image type: " << pfname;
		BOOST_THROW_EXCEPTION(std::runtime_error(str.str()));
	}
}

