#include "gfx/generic.hpp"

#include <sstream>

using namespace gfx;

void gfx::check_opengl_errors()
{
	GLenum glerr = glGetError();
	if(glerr != GL_NO_ERROR)
	{
		std::stringstream err;
		err << "OpenGL error: " <<
			reinterpret_cast<const char*>(gluErrorString(glerr));
		BOOST_THROW_EXCEPTION(std::runtime_error(err.str()));
	}
}

