#include "ft_glyph.hpp"

#include <sstream>
#include <string.h>

FtGlyph::FtGlyph(int pcode, float pw, float ph, float pleft, float ptop,
		float pax, float pay, unsigned bw, unsigned bh, uint8_t *bdata) :
	_unicode(pcode),
	_width(pw),
	_height(ph),
	_left(pleft),
	_top(ptop),
	_advance_x(pax),
	_advance_y(pay),
	_bitmap_w(bw),
	_bitmap_h(bh),
	_bitmap(bdata)
{
	// Do nothing.
}

FtGlyph::~FtGlyph()
{
	delete[] _bitmap;
}

void FtGlyph::copy(uint8_t *tgt, unsigned tw, unsigned idx)
{
	unsigned div = tw / _bitmap_w,
		 			 row = idx / div,
					 col = idx % div,
					 linesize = _bitmap_w * sizeof(uint8_t);

	tgt += row * _bitmap_h * tw + col * _bitmap_w;

	for(unsigned ii = 0; (ii < _bitmap_h); ++ii)
	{
		memcpy(tgt + ii * tw, _bitmap + ii * _bitmap_w, linesize);
	}
}

void FtGlyph::write(FILE *fptr)
{
	std::stringstream sstream;

	sstream << "\t<glyph>\n" <<
		"\t\t<code>" << _unicode << "</code>\n" <<
		"\t\t<width>" << _width << "</width>\n" <<
		"\t\t<height>" << _height << "</height>\n" <<
		"\t\t<left>" << _left << "</left>\n" <<
		"\t\t<top>" << _top << "</top>\n" <<
		"\t\t<advance_x>" << _advance_x << "</advance_x>\n" <<
		"\t\t<advance_y>" << _advance_y << "</advance_y>\n" <<
		"\t\t<s1>" << _s1 << "</s1>\n" <<
		"\t\t<t1>" << _t1 << "</t1>\n" <<
		"\t\t<s2>" << _s2 << "</s2>\n" <<
		"\t\t<t2>" << _t2 << "</t2>\n" <<
		"\t\t<page>" << _page << "</page>\n" <<
		"\t</glyph>\n";

	fputs(sstream.str().c_str(), fptr);
}

