#ifndef FT_FACE_HPP
#define FT_FACE_HPP

#include "ft2build.h"
#include FT_FREETYPE_H

//#include <inttypes.h>
#include <stdexcept>
#include <string>

class FtGlyph;

/** \brief Class representing one freetype font.
 */
class FtFace
{
	private:
		/** Freetype library handle. */
		static FT_Library ftlib;

	private:
		/** Font face associated with this. */
		FT_Face _face;

		/** Size associated with this face. */
		int _size;

	public:
		/** \brief Default constructor.
		 *
		 * Throws an exception on error.
		 *
		 * @param filename Font file to open.
		 */
		FtFace(const std::string &filename) throw(std::runtime_error);

		/** \brief Destructor.
		 */
		~FtFace();

	public:
		/** \brief Tell if this has a glyph.
		 *
		 * @param unicode Unicode glyph number.
		 * @return True if yes, false if no.
		 */
		bool hasGlyph(int unicode);

		/** \brief Loads a glyph.
		 *
		 * @param unicode Unicode glyph number.
		 * @param targetsize
		 * @return Glyph object if successful, false on error.
		 */
		FtGlyph* renderGlyph(unsigned unicode, unsigned targetsize);

		/** \brief Set the size from which the calculations will be done.
		 *
		 * This is a square. Use reasonable values.
		 *
		 * @param sz Size to use.
		 */
		void setSize(int sz);

	private:
		/** \brief Crunch a glyph using the Valve algorithm.
		 *
		 * @param targetsize Size to crunch to.
		 * @return Newly reserved array.
		 */
		uint8_t* crunch(unsigned targetsize);
};

#endif // FT_GLYPH_HPP
