#include "data/store.hpp"

#include <boost/filesystem.hpp>

namespace fs = boost::filesystem;
using namespace data;

std::string data::store_name_canonize(const std::string &op)
{
	return fs::path(op).stem();
}

std::string data::store_name_loaderize(const std::string &op)
{
	fs::path pth(op);
	return (pth.parent_path() / pth.stem()).file_string();
}

