#!/usr/bin/python
# -*- coding: utf-8 -*-

conf_test = """
#ifdef __APPLE__
#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
#else
#include <GL/gl.h>
#include <GL/glu.h>
#endif

int main() { glBegin; gluOrtho2D; }
"""

def CheckOpenGL(context):
  import os
  context.Message('Checking for OpenGL... ')
  libs = context.env.get('LIBS')
  frameworks = context.env.get('FRAMEWORKS')
  
  if os.name == 'nt': # System is Windows...
    context.env.Append(LIBS = ['opengl32', 'glu32'])

  elif os.uname()[0] == 'Darwin': # ... Mac OS X ...
    context.env.Append(FRAMEWORKS = ['OpenGL'])

  else: # ... Any other
    context.env.Append(LIBS = ['GL', 'GLU'])

  res = context.TryLink(conf_test, '.cpp')
  if not res:
    context.env.Replace(LIBS = libs)
    context.env.Replace(FRAMEWORKS = frameworks)
  context.Result(res)
  return res

