#!/bin/sh

DSTPATH="$1"
if test -d "$DSTPATH" ; then
	echo "Copying relevant files to $DSTPATH"
else
	echo "Not a directory: \"$DSTPATH\""
	exit 1
fi

diff_copy()
{
	if test -f "$1" ; then
		if test -f "$2" ; then
			diff -q $1 $2
			if test "$?" -ne "0" ; then
				echo "Replacing $2 with $1"
				cp $1 $2
			fi
		else
			echo "Installing $1 to $2"
			cp $1 $2
		fi
	fi
}

dstcp()
{
	diff_copy "$1" "$DSTPATH/$1"
}

dstcp "fnt/default.xml"
dstcp "fnt/default_0.png"
dstcp "fnt/default_1.png"
dstcp "fnt/default_2.png"
dstcp "gfx/surf_bk.png"
dstcp "gfx/surf_dn.png"
dstcp "gfx/surf_fw.png"
dstcp "gfx/surf_lt.png"
dstcp "gfx/surf_rt.png"
dstcp "gfx/surf_up.png"
dstcp "shader/2d.xml"
dstcp "shader/2d_font.xml"
dstcp "shader/2d_texture.xml"
dstcp "shader/3d_world.xml"

dstcp "src/data/data_generic.cpp"
dstcp "src/data/generic.hpp"
dstcp "src/defaults.hpp"
dstcp "src/gfx/attribute.hpp"
dstcp "src/gfx/buffer.cpp"
dstcp "src/gfx/buffer.hpp"
dstcp "src/gfx/array.hpp"
dstcp "src/gfx/color.cpp"
dstcp "src/gfx/color.hpp"
dstcp "src/gfx/edge.hpp"
dstcp "src/gfx/entity.cpp"
dstcp "src/gfx/entity.hpp"
dstcp "src/gfx/entity_camera.cpp"
dstcp "src/gfx/entity_camera.hpp"
dstcp "src/gfx/entity_object.cpp"
dstcp "src/gfx/entity_object.hpp"
dstcp "src/gfx/font.cpp"
dstcp "src/gfx/font.hpp"
dstcp "src/gfx/generic.hpp"
dstcp "src/gfx/glyph.cpp"
dstcp "src/gfx/glyph.hpp"
dstcp "src/gfx/height_map_ball.cpp"
dstcp "src/gfx/height_map_ball.hpp"
dstcp "src/gfx/image.cpp"
dstcp "src/gfx/image.hpp"
dstcp "src/gfx/light_directional.hpp"
dstcp "src/gfx/lod.cpp"
dstcp "src/gfx/lod.hpp"
dstcp "src/gfx/lod_icosahedron.cpp"
dstcp "src/gfx/lod_icosahedron.hpp"
dstcp "src/gfx/mesh.cpp"
dstcp "src/gfx/mesh.hpp"
dstcp "src/gfx/mesh_animated.cpp"
dstcp "src/gfx/mesh_animated.hpp"
dstcp "src/gfx/mesh_ball.cpp"
dstcp "src/gfx/mesh_ball.hpp"
dstcp "src/gfx/mesh_icosahedron.cpp"
dstcp "src/gfx/mesh_icosahedron.hpp"
dstcp "src/gfx/mesh_planet.cpp"
dstcp "src/gfx/mesh_planet.hpp"
dstcp "src/gfx/mesh_static.cpp"
dstcp "src/gfx/mesh_static.hpp"
dstcp "src/gfx/shader.cpp"
dstcp "src/gfx/shader.hpp"
dstcp "src/gfx/surface.cpp"
dstcp "src/gfx/surface.hpp"
dstcp "src/gfx/surface_base.cpp"
dstcp "src/gfx/surface_base.hpp"
dstcp "src/gfx/surface_screen.cpp"
dstcp "src/gfx/surface_screen.hpp"
dstcp "src/gfx/texture.hpp"
dstcp "src/gfx/texture_2d.cpp"
dstcp "src/gfx/texture_2d.hpp"
dstcp "src/gfx/texture_3d.cpp"
dstcp "src/gfx/texture_3d.hpp"
dstcp "src/gfx/triangle.hpp"
dstcp "src/gfx/uniform.hpp"
dstcp "src/math/generic.hpp"
dstcp "src/math/mat.hpp"
dstcp "src/math/rect.hpp"
dstcp "src/math/vec.hpp"
dstcp "src/ui/event.hpp"
dstcp "src/ui/event_key.hpp"
dstcp "src/ui/event_misc.hpp"
dstcp "src/ui/event_mouse_button.hpp"
dstcp "src/ui/event_mouse_motion.hpp"
dstcp "src/ui/fps_counter.cpp"
dstcp "src/ui/fps_counter.hpp"
dstcp "src/ui/generic.hpp"
dstcp "src/ui/text_area.cpp"
dstcp "src/ui/text_area.hpp"
dstcp "src/ui/text_box.cpp"
dstcp "src/ui/text_box.hpp"
dstcp "src/ui/text_row.cpp"
dstcp "src/ui/text_row.hpp"
dstcp "src/ui/text_word.cpp"
dstcp "src/ui/text_word.hpp"
dstcp "src/ui/ui_generic.cpp"
dstcp "src/ui/ui_stack.cpp"
dstcp "src/ui/ui_stack.hpp"
dstcp "src/ui/ui_state.cpp"
dstcp "src/ui/ui_state.hpp"

dstcp "src/ob_height_map_planet.cpp"
dstcp "src/ob_height_map_planet.hpp"
dstcp "src/ob_main.cpp"
dstcp "src/ob_planet.cpp"
dstcp "src/ob_planet.hpp"

exit 0
