/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _TRAP_H
#define _TRAP_H
#include "ant.h"
#include "object.h"

class world;
class trap : public object {
	public:
		enum trap_type {
			explosive,
			paralyse,
		
			trap_type_count
		};

		trap(trap_type t, animation_loader *l);
		void trigger(ant *, world &w);
		void hit(ant *a, world &w);
		
		virtual void update(world &w);

		virtual bool collision(const object &) const;
		double get_delay_time() { return delay_time; }

		trap_type get_type() { return type; }
	private:
		trap_type type;
		double delay_time;
		bool triggered;
		double time_left;
	
		static const char *trap_anims[trap_type_count];

};

#endif

