/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "trap.h"
#include "world.h"

const char* trap::trap_anims[trap::trap_type_count] = {
	"explosive_trap",
	"paralyse_trap"
};

trap::trap(trap_type t, animation_loader *l) :
	object(l?&l->get_animation(trap_anims[t]):0),
	type(t), delay_time(0.0f), triggered(false)
{
	set_w(26);
	set_h(26);
	set_mode("stand");
	switch(t) {
		case explosive:
			delay_time = 1.0f;
		break;
		case paralyse:
			delay_time = 0.1f;
		break;
		default:
		break;
	}
}

void trap::update(world &w)
{
	if(!triggered) {
		std::vector<ant*> & ants = w.get_ants();
		for(unsigned int a = 0; a < ants.size(); a++) {
			if(collision(*ants[a])) {
				trigger(ants[a], w);
				break;
			}
		}
	} else {
		time_left -= DT;
		if(time_left <= 0) {
			dead = true;
			ant *a = dynamic_cast<ant*>(get_target());
			if(a) {
				hit(a, w);
			}
		}
	}

	object::update(w);
}

void trap::hit(ant *a, world &w)
{
	switch(type) {
		case explosive:
		{
			std::vector<ant*> &ants = w.get_ants();
			for(size_t b = 0; b < ants.size(); b++) {
				if(dist(get_center(), ants[b]->get_center()) <= 120.0f) {
					ants[b]->add_hp(-ants[b]->get_max_hp()*0.4);
				}
			}
		}
		break;
		case paralyse:
			a->paralyse(6.0f);
		break;
		default:
		break;
	}
}

void trap::trigger(ant *a, world &w)
{
	set_mode("triggered");
	set_target(a);
	time_left = delay_time;
	triggered = true;

	w.handler.trap_trigger(this, a);
}

bool trap::collision(const object &obj) const
{
	const creature *p = dynamic_cast<const creature*>(&obj);
	if(!p || p->get_type() != creature::griffin) {
		return object::collision(obj);
	}
	return false;
}
