/***************************************************************************
*   Copyright (C) 2010 by
*    Santtu Keskinen <laquendi@gmail.com>
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _SPELLHOTKEY_H
#define _SPELLHOTKEY_H

#include <SFML/Window.hpp>
#include "settings.h"
#include "config.h"

class world;
class spell;

class spell_hotkey_handler
{
	public:
		enum spell_hotkey_mode {
			hotkey,
			positional
		};
		spell_hotkey_handler();
		bool pressed(sf::Key::Code code, world& w, spell &cur_spell);
		spell_hotkey_mode get_mode() { return mode;  }
	private:
		spell_hotkey_mode mode;
		int layout[HOTKEYS];

};

#endif
