/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#include "spell_emitter.h"
#include <iostream>

particle spell_emitter::create()
{
	double life = uniform_dist(1.0f, 0.3f);
	sf::Color col = sf::Color(uniform_dist(128, 127), uniform_dist(128, 127), 
			uniform_dist(128, 127));
	sf::Vector2f vel = sf::Vector2f(uniform_dist(0.0f, 30.0f), uniform_dist(0.0f, 30.0f));
	sf::Vector2f accel = sf::Vector2f(uniform_dist(0.0f, 200.0f), uniform_dist(0.0f, 200.0f));

	return particle(life, col, pos, vel, accel);
}

particle explosion_emitter::create()
{
	double life = uniform_dist(0.7f, 0.2f);
	sf::Color col = sf::Color(uniform_dist_r(100, 255), 
			uniform_dist(20, 20), 
			uniform_dist(20, 20));
	sf::Vector2f vel = sf::Vector2f(uniform_dist(0.0f, 80.0f), uniform_dist(-55.0f, 70.0f));
	sf::Vector2f accel = sf::Vector2f(0, uniform_dist_r(150.0f, 250.0f));

	return particle(life, col, pos, vel, accel);
}
