/***************************************************************************
*   Copyright (C) 2010 by
*    Kai Lindholm <megantti@gmail.com>
*    Santtu Keskinen <laquendi@gmail.com>
*   
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
* 
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*   
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
****************************************************************************/

#ifndef _SPELL_H
#define _SPELL_H

#include <string>
#include <algorithm>
#include <vector>
#include "pauseclock.h"

class world;
class selectable;

class spell_info_container;
class spell {
	public:
		enum spell_type {
			cc_grow_mushroom,
			cc_connect,
			cc_fertilize_str,
			cc_fertilize_mana,
			cc_fertilize_dur,
			
			mushroom_upg_to_attack,
			mushroom_upg_to_spore,
			mushroom_upg_to_tank,
			mushroom_connect,
			mushroom_multiply,
			mushroom_give_energy,
			mushroom_attack_wall,
			mushroom_target_ant,
			mushroom_paralyse,
			mushroom_heal,
			mushroom_taunt,
			
			unicorn_invisibility,
			unicorn_dimension_door,
			unicorn_mana_orb,
			unicorn_diagonal_spawn,
			unicorn_spawn_mushroom,
			unicorn_resurrect,
			
			minotaur_attack_stance,
			minotaur_throw_mushroom,
			minotaur_build_cc,
			minotaur_mass_connect,
			minotaur_attack_wall,
			minotaur_ants_bane,
			
			griffin_paralyse_trap,
			griffin_kill_ant,
			griffin_eat_mushroom,
			griffin_explosive_trap,
			griffin_boost_stats,
			griffin_immortality,

			spell_count
		};

		spell();
		spell(spell_type t);
		
		bool can_cast(selectable *caster, sf::Vector2f pos, world &w) const;
		bool in_range(selectable *caster, sf::Vector2f pos, world &w) const;
		bool cast(selectable *caster, sf::Vector2f pos, world &w) const;


		void pause() { cast_clock.pause(); }
		void unpause() {cast_clock.unpause(); }
		void update();
		void update_cooldown(const float &cd);

		float get_cur_cooldown() const;
		float get_cooldown_phase() const;
		float get_s_cd() const;
		float get_g_cd() const;
		int get_energy_cost(selectable *caster) const; 
		float get_range(selectable *caster) const;
		std::string get_animation() const;
		
		std::vector<std::string> get_desc(selectable *caster, bool show_hotkey) const;
		bool get_check_los() const;
		spell_type get_spell_type() const { return t; }
		bool need_target() const;
		char get_hotkey() const;
		int get_req_level() const;
		int get_y_limit() const;

		bool available(selectable* caster, world &w);
		bool is_dummy() { return t == spell_count; }
		
		int get_id() const { return id; }
		void set_id(int _id) { id = _id; }
	private:
		int id;
		spell_type t;
		float cooldown;
		pclock cast_clock;
		
		spell_info_container *spell_infos;
		
		friend class spell_info_container;
};


class spell_info_container;
class spell_info {
	public:
		enum target_type {
			ground,
			mushroom,
			mushroom_growing,
			command_center,
			wall,
			ant,
			none
		};		
	
		spell_info(std::string _name, std::string _animation) : name(_name), animation(_animation), desc(""), 
		s_cd(0.0), g_cd(3.5), e_cost(0), range(100), check_los(true), 
		target(none), hotkey(-1), req_level(0), y_limit(-1) {}
		spell_info(){}
		std::string name;
		std::string animation;
		std::string desc;
		spell_info& set_desc(std::string _desc) { desc = _desc; return *this; }
		float s_cd;
		spell_info& set_s_cd(float _s_cd) { s_cd = _s_cd; return *this; }
		float g_cd;
		spell_info& set_g_cd(float _g_cd) { g_cd = _g_cd; return *this; }
		int e_cost;
		spell_info& set_e_cost(int _e_cost) { e_cost = _e_cost; return *this; }
		float range;
		spell_info& set_range(float _range) { range = _range; return *this; }
		bool check_los;
		spell_info& set_check_los(bool _check_los) { check_los = _check_los; return *this; }
		target_type target;
		spell_info& set_target(target_type _target) { target = _target; return *this; }
		char hotkey;
		spell_info& set_hotkey(char _hotkey) { hotkey = _hotkey; return *this; }
		int req_level;
		spell_info& set_req_level(int _req_level) { req_level = _req_level; return *this; }
		int y_limit;
		spell_info& set_y_limit(int _y_limit) { y_limit = _y_limit; return *this; }
};

class spell_info_container {
		std::vector<spell_info> infos;
		
		spell_info_container();
		~spell_info_container()	
		{
			if(handle)
				delete handle;
		}
		static spell_info_container *handle;

	public:
		static spell_info_container* get_handle();
		spell_info& at(int i) { return infos[i]; }
};

#endif

